/*
    Nucleo F401RE Board
    DMA Transmit sample   

    I2S Master Transmit (Enable MCK out)
    Phillips Format 16bit
    Dubble DMA Buffer




*/

#include "mbed.h"
#include <math.h>
#include "cmsis.h"
#include "pinmap.h"
#include "PinNames.h"
#include "error.h"
#include "stm32f401xe.h"
#include "stm32f4xx.h"
#include "stm32f4xx_hal.h"
#include "stm32f4xx_hal_dma_ex.h"
#include "stm32f4xx_hal_dma.h"
#include "stm32f4xx_hal_i2s.h"
#include "sine_wave.h"
#include "saw_wave.h"
#include "ST_F401_84MHZ.h" 

Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut myled(LED1);

#define I2S_BUFFERSIZE 256
#define DMA_TRANSFERCOUNT (I2S_BUFFERSIZE<<1) 
int16_t dmabuffer[2][DMA_TRANSFERCOUNT];//DMA Double Buffer

static const PinMap PinMap_I2S_MCK[] = {
    {PC_6,  SPI_2, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, GPIO_AF5_SPI2)},
//    {PC_7,  SPI_3, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, GPIO_AF6_SPI3)},
    {NC,    NC,    0}
};

static const PinMap PinMap_I2S_CK[] = {
    {PB_10,  SPI_2, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, GPIO_AF5_SPI2)},
    {PB_13,  SPI_2, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, GPIO_AF5_SPI2)},
//    {PD_3,  SPI_2, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, GPIO_AF5_SPI2)},
//    {PC_10,  SPI_3, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, GPIO_AF6_SPI3)},
    {NC,    NC,    0}
};

static const PinMap PinMap_I2S_WS[] = {
    {PB_12,  SPI_2, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, GPIO_AF5_SPI2)},
    {PB_9,  SPI_2, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, GPIO_AF5_SPI2)},
//    {PA_15,  SPI_3, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, GPIO_AF6_SPI3)},
    {NC,    NC,    0}
};

static const PinMap PinMap_I2S_SD[] = {
    {PC_3,  SPI_2, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, GPIO_AF5_SPI2)},
    {PB_15,  SPI_2, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, GPIO_AF5_SPI2)},
//    {PC_12,  SPI_3, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, GPIO_AF6_SPI3)},
//    {PD_6,  SPI_3, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, GPIO_AF5_SPI3)},
    {NC,    NC,    0}
};

   
  DMA_InitTypeDef DMA_InitType ={
    DMA_CHANNEL_0,
    DMA_MEMORY_TO_PERIPH,
    DMA_PINC_DISABLE,
    DMA_MINC_ENABLE,             
    DMA_PDATAALIGN_HALFWORD,
    DMA_MDATAALIGN_WORD,
    DMA_CIRCULAR,//DMA_PFCTRL,//
    DMA_PRIORITY_HIGH,
    DMA_FIFOMODE_DISABLE,//DMA_FIFOMODE_ENABLE,
    DMA_FIFO_THRESHOLD_HALFFULL,
    DMA_MBURST_SINGLE,
    DMA_PBURST_SINGLE
   };

DMA_HandleTypeDef DMA_HandleType ={
    DMA1_Stream4,
    DMA_InitType,
    HAL_UNLOCKED,
    HAL_DMA_STATE_RESET,//HAL_DMA_STATE_READY
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL    
};

I2S_InitTypeDef my_I2S_InitType ={
    I2S_MODE_MASTER_TX,
    I2S_STANDARD_PHILLIPS,
    I2S_DATAFORMAT_16B,
    I2S_MCLKOUTPUT_ENABLE,
    I2S_AUDIOFREQ_44K,
    I2S_CPOL_LOW,
    I2S_CLOCK_PLL,
    I2S_FULLDUPLEXMODE_DISABLE    
};

HAL_I2S_StateTypeDef my_I2S_StateTypeDef={
   HAL_I2S_STATE_RESET     
};

HAL_I2S_ErrorTypeDef my_I2S_ErorTypeDef={
    HAL_I2S_ERROR_NONE
};
    
I2S_HandleTypeDef my_I2S_HandleTypeDef = {
     SPI2,
     my_I2S_InitType,
     (uint16_t*)&dmabuffer[0][0],  
     I2S_BUFFERSIZE,
     NULL,
     NULL,
     NULL,
     NULL,
     &DMA_HandleType,//&my_DMA_HamdleType,    
     NULL,
     HAL_UNLOCKED, 
     my_I2S_StateTypeDef,
     my_I2S_ErorTypeDef  
};    

void init_dmabuffer(void){
    for (int i =0;i < I2S_BUFFERSIZE;i++){
        dmabuffer[0][i*2] = sine_wave[i];// 1st Buffer Lch 
        dmabuffer[0][i*2+1] = saw_wave[i];// 1nd Buffer Rch 
        dmabuffer[1][i*2] = sine_wave[i];// 2nd Buffer Lch
        dmabuffer[1][i*2+1] = saw_wave[i];// 2nd Buffer Rch
    }
}

#define PLLI2S_N  271
#define PLLI2S_R  2
    
int main() {
    F401_init84 myinit(0); 
    pc.baud(9600);
    pc.printf("CPU SystemCoreClock is %d Hz\r\n", SystemCoreClock);
    init_dmabuffer();
    
    /* Configure the I2S PLL */
    RCC->PLLI2SCFGR = (PLLI2S_N << 6) | (PLLI2S_R << 28);
    /* Enable the I2S PLL */
    RCC->CR |= RCC_CR_PLLI2SON;
    /* Wait until the I2S PLL is ready */
    while (!(RCC->CR & RCC_CR_PLLI2SRDY));

    __SPI2_CLK_ENABLE();
    __DMA1_CLK_ENABLE();

    pinmap_pinout(PC_6, PinMap_I2S_MCK);
    pinmap_pinout(PB_13, PinMap_I2S_CK);
    pinmap_pinout(PB_12, PinMap_I2S_WS);
    pinmap_pinout(PB_15, PinMap_I2S_SD);

    pin_mode(PC_6, PullUp);
    pin_mode(PB_13, PullUp);
    pin_mode(PB_12, PullUp);
    pin_mode(PB_15, PullUp);
 
    if(HAL_DMA_Init(&DMA_HandleType)!= HAL_OK) pc.printf("Eror in HAL_DMA_Init \n\r");
    
    if (HAL_I2S_Init(&my_I2S_HandleTypeDef)!= HAL_OK)  pc.printf("Eror in HAL_I2S_Init \n\r");

    volatile uint32_t *I2S_DR = &SPI2->DR; 
    if(HAL_DMAEx_MultiBufferStart_IT(&DMA_HandleType ,(uint32_t)&dmabuffer[0][0] ,(uint32_t )I2S_DR ,(uint32_t)&dmabuffer[1][0] ,DMA_TRANSFERCOUNT)!=HAL_OK) pc.printf("Eror in HAL_DMAEx_MultiBufferStart_IT \n\r");

     SPI2->I2SCFGR |= SPI_I2SCFGR_I2SE;
     /* Enable Tx DMA Request */  
     SPI2->CR2 |= SPI_CR2_TXDMAEN;

    pc.printf("DMA M0AR =%4x M1AR =%4x PAR = %4x \n\r"  ,DMA1_Stream4->M0AR  ,DMA1_Stream4->M1AR ,DMA1_Stream4->PAR);
    pc.printf("I2S CR2 = %4x \n\r" ,SPI2->CR2);
    pc.printf("I2S SR = %4x \n\r" ,SPI2->SR);
    pc.printf("I2S I2SCFGR = %4x \n\r" ,SPI2->I2SCFGR);
    pc.printf("I2S I2SPR = %4x \n\r" ,SPI2->I2SPR);
    pc.printf("RCC->PLLI2SCFGR = %4x \n\r" ,RCC->PLLI2SCFGR);
 
    HAL_RCC_MCOConfig(uint32_t RCC_MCO2, RCC_MCO2SOURCE_PLLI2SCLK, RCC_MCODIV_5);
 
  while(1) { 
        wait_ms(500);
  }
}
 