#include "mbed.h"
#include "I2CMasterRtos.h"

#ifndef _MPL3115A2_H_
#define _MPL3115A2_H_

#define OFFSET 0x00  //Set for location this is the Altitude offset in meters

#define SLAVE_ADDRESS 0xC0

#define STARTING_REGISTER 0x01

class MPL3115A2
{
public:
    MPL3115A2(PinName pin1, PinName pin2);
    //MPL3115A2(int SlaveAddress, PinName pin1, PinName pin2, PinName pin3, PinName pin4);
    
    bool   init (void);
    
    bool getInterrupt1(void);
    bool getInterrupt2(void);
    
    float Temp_F(void);
    float Temp_C(void);
    
    float Altitude_ft(void);
    float Altitude_m(void);

private:
    int Write_Register (char regnum, char data);
    int Read_Altitude_Data(void);
    
    char _SensorData[8];    //Char array that holds the current Altitude and Temperature data
    
    I2CMasterRtos _i2c;
    //DigitalIn _pin1;
    //DigitalIn _pin2;
};
#endif
