#include "MPL3115A2.h"

//MPL3115A2 Class Constructor
/*
MPL3115A2::MPL3115A2(int SlaveAddress, PinName pin1, PinName pin2, PinName pin3, PinName pin4) : _i2c(pin1,pin2), _pin1(pin3),_pin2(pin4)
{
    _pin1.mode(PullUp);
    _pin2.mode(PullUp);
    SLAVE_ADDRESS = SlaveAddress;

}
*/

MPL3115A2::MPL3115A2(PinName pin1, PinName pin2): _i2c(pin1,pin2)
{
    _i2c.frequency(400000);
}

int MPL3115A2::Write_Register (char regnum, char data)   //Used for writing data to the MPL3115A2 Registers
{
    char Write_Data[2];
    Write_Data[0] = regnum;
    Write_Data[1] = data;

    return(_i2c.write(SLAVE_ADDRESS, Write_Data, 2));
}

// Initialize the MPL3115A2 in Altitude Interrupt Mode
bool MPL3115A2::init(void)
{
    int status = -1;
    status = Write_Register(0x26, 0xB9);//0xB8);

    if (!status)
        status = Write_Register(0x13,0x07);

    if (!status)
        status = Write_Register(0x29,0x80);

    /*
    if(status==0) {
        status = -1;
        status = Write_Register(0x2d,OFFSET);
    }
    */

    if (!status)
        status = Write_Register(0x28,0x11);

    if (!status)
        return true;
    else
        return false;
}

/*
bool MPL3115A2::getInterrupt1(void)   //Return state of Int1 pin
{
    return(_pin1.read());
}

bool MPL3115A2::getInterrupt2(void)	  //Return state of Int2 pin
{
    return(_pin2.read());
}
*/


int MPL3115A2::Read_Altitude_Data(void)		//Read Data Register from MPL3115A2 Sensor
{
    char cmd[2] = {0x01};
    _i2c.write(SLAVE_ADDRESS, cmd, 1, true);
	
    return(_i2c.read(SLAVE_ADDRESS, _SensorData, 5));
}

// Return Altitude in Feet
float MPL3115A2::Altitude_ft ()
{
    if (!Read_Altitude_Data())
        return (((_SensorData[2]>>4)/128.0) + (_SensorData[0]*256+_SensorData[1])) * 3.28;
    else
        return -1;
}

// Return Altitude in meters
float MPL3115A2::Altitude_m ()
{
    if (!Read_Altitude_Data())
        return ((_SensorData[2]>>4)/128.0) + (_SensorData[0]*256+_SensorData[1]);
    else
        return -1;
}

// Return Temp in Degrees F
float MPL3115A2::Temp_F ()
{
    if (!Read_Altitude_Data())
        return ((_SensorData[4]>>4)/128.0 + (float)_SensorData[3])*1.8 + 32.0;
    else
        return -1;
}

// Return Temp in Degrees C
float MPL3115A2::Temp_C ()
{
    if (!Read_Altitude_Data())
        return (_SensorData[4]>>4)/128.0 + (float)_SensorData[3];
    else
        return -1;
}
