// exchange messages betwen the LPC1768's two i2c ports using low level read/write/start/stop commands
// changing master and slave mode on the fly

#include "mbed.h"
#include "rtos.h"
#include "I2CMasterRtos.h"
#include "I2CSlaveRtos.h"

const int freq = 400000;
const int adr = 42<<1;
const int len=34;
const char mstMsg[len]="We are mbed, resistance is futile";
const char slvMsg[len]="Fine with me, let's get addicted ";

static void slvRxMsg(I2CSlaveRtos& slv)
{
    char rxMsg[len];
    memset(rxMsg,0,len);
    if ( slv.receive() == I2CSlave::WriteAddressed ) {
        int cnt=0;
        while(cnt<len) rxMsg[cnt++]=slv.read();
        slv.stop(); // stop sretching low level of scl
        printf("thread %x received message (sz=%d) as i2c slave: '%s'\n",Thread::gettid(),cnt,rxMsg);
    } else
        printf("Ouch slv rx failure\n");
}

static void slvTxMsg(I2CSlaveRtos& slv)
{
    if ( slv.receive()==I2CSlave::ReadAddressed) {
        int cnt=0;
        while(cnt<len && slv.write(slvMsg[cnt++]));
        slv.stop(); // stop sretching low level of scl
    } else
        printf("Ouch slv tx failure\n");
}

static void mstTxMsg(I2CMasterRtos& mst)
{
    mst.start();
    if(!mst.write(adr & 0xfe))printf("adr+W not acked\n");
    int cnt=0;
    while(cnt<len && mst.write(mstMsg[cnt++]));
    // give the slave a chance to stop stretching scl to low, otherwise we will busy wait for the stop forever
    while(!mst.stop())Thread::wait(1);
}

static void mstRxMsg(I2CMasterRtos& mst)
{
    char rxMsg[len];
    memset(rxMsg,0,len);
    
    mst.lock(); // no special reason, just a test
    mst.start();
    if(!mst.write(adr | 0x01))printf("adr+R not acked\n");
    int cnt=0;
    while(cnt<len-1) rxMsg[cnt++]=mst.read(1);
    mst.unlock();
    rxMsg[cnt++]=mst.read(0);
    // give the slave a chance to stop stretching scl to low, otherwise we will busy wait for the stop forever
    while(!mst.stop())Thread::wait(1);
    printf("thread %x received message (sz=%d) as i2c master: '%s'\n",Thread::gettid(),cnt,rxMsg);
}

static void channel1(void const *args)
{
    I2CMasterRtos mst(p9,p10,freq);
    I2CSlaveRtos slv(p9,p10,freq,adr);
    while(1) {
        slvRxMsg(slv);
        slvTxMsg(slv);
        Thread::wait(100);
        mstTxMsg(mst);
        Thread::wait(100);
        mstRxMsg(mst);
    }
}

void channel2(void const *args)
{
    I2CMasterRtos mst(p28,p27,freq);
    I2CSlaveRtos slv(p28,p27,freq,adr);
    while(1) {
        Thread::wait(100);
        mstTxMsg(mst);
        Thread::wait(100);
        mstRxMsg(mst);
        slvRxMsg(slv);
        slvTxMsg(slv);
    }
}

int doit()
{
    Thread selftalk01(channel1,0);
    Thread selftalk02(channel2,0);
    Thread::wait(5000);
    return 0;
}

