#include "mbed.h"

const char H = 0;
const char L = 1;

DigitalOut ABB(P0_23);

DigitalOut DG(P0_14);
DigitalOut CLK(P0_13);
DigitalOut WE(P0_12);
DigitalOut DR(P0_11);
DigitalOut ALE(P0_22);

DigitalOut LED(LED3);

int main() {
    // initialize
    DG = L;
    DR = L;
    CLK = L;
    ALE = L;
    WE = L;
    ABB = L;
    
    CLK = H;
    wait_ms(100);
    CLK = L;
    wait_ms(100);
    
    // data
    ABB = H; // RAM-A
    wait_ms(100);
    CLK = H;
    wait_ms(100);
    CLK = L;
    wait_ms(100);
    
    ABB = L; // RAM-B
    wait_ms(100);
    CLK = H;
    wait_ms(100);
    CLK = L;
    wait_ms(100);
    
    ABB = H; // RAM-A
    wait_ms(100);
    CLK = H;
    wait_ms(100);
    CLK = L;
    wait_ms(100);
    
    for(char i = 0; i < 12; ++i) {
        DG = H;
        wait_ms(100);
        CLK = H;
        wait_ms(100);
        CLK = L;
        wait_ms(100);
        
        DG = L;
        wait_ms(100);
        CLK = H;
        wait_ms(100);
        CLK = L;
        wait_ms(100);
    }
    
    // latch
    ALE = H;
    wait_ms(100);
    CLK = H;
    wait_ms(100);
    CLK = L;
    wait_ms(100);
    
    WE = H;
    wait_ms(100);
    CLK = H;
    wait_ms(100);
    CLK = L;
    wait_ms(100);
    
    WE = L;
    wait_ms(100);
    CLK = H;
    wait_ms(100);
    CLK = L;
    wait_ms(100);
    
    ALE = L;
    wait_ms(100);
    CLK = H;
    wait_ms(100);
    CLK = L;
    wait_ms(100);
    
    ABB = L; // RAM-B
    wait_ms(100);
    CLK = H;
    wait_ms(100);
    CLK = L;
    wait_ms(100);
    
    // finish
    LED = 1;
    wait(3);
    LED = 0;
    
    while(true);
}
