#include "mbed.h"
#include "patterns.cpp"

DigitalOut RCK(D10);// 74595
DigitalOut G(D9);   // 74595
DigitalOut SER(D8); // 74164
DigitalOut CLK(D7); // 74164
DigitalIn BUTTON(USER_BUTTON); // 点灯・消灯ボタン
//Serial pc(USBTX, USBRX); // USBシリアル通信
Timer timer; // 経過時間のカウンター
const unsigned char HI = 0;
const unsigned char LO = 1;
const unsigned char MODE = 2; //SPI

char scan = 16; // 点灯中の行
//int round = 0; // スキャンを何周したか
//int scroll = 0; // 左スクロールした量
char speed = 30-29; // スクロール進段ミリ秒
int t = 0; // 経過時間

void receive() { // シリアル受信割り込み
//    if(pc.getc() == 0b00000001) pc.printf("received!\r\n");
//    pc.putc(pc.getc() + 1); // echo
}

//unsigned char getPattern(char const *p, char x, char y, bool s) {
//    unsigned char r;
//    r = (unsigned char)p[x][4*11-1-y%(4*11)];
//    return r;
//}

int main() {
    SPI spi(D11, D12, D13); // SPIピン mosi, miso, sclk
    spi.format(8, MODE); // 74595へ～ビットずつ送る //立ち下りクロック
    spi.frequency(1*1000*1000); // 74595へのクロック周波数 最高96 初期1
//    pc.attach(receive, Serial::RxIrq); // シリアル受信割り込み
//    pc.baud(9600); // シリアル通信のクロックレート デフォルト9600
    timer.start(); // 経過時間のカウントを開始
    timer.reset(); // 経過時間0秒

    spi.write(pattern2[0][0]
        + pattern5[0][0]
        + pattern_bus1[0][0]
        + pattern_bus2[0][0]
        + pattern_bus3[0][0]
        + pattern_bus4[0][0]
        + pattern_bus5[0][0]
        + pattern_bus6[0][0]
        + pattern_8k_kaisoku_sho[0][0]
        + pattern_8k_yayoi_tsugi[0][0]
        + pattern_8k_yayoi_next[0][0]
        + pattern_8k_izu_tsugi[0][0]
        + pattern_8k_izu_next[0][0]
        + pattern_8k_izuchi_tsugi[0][0]
        + pattern_8k_izuchi_next[0][0]
        + pattern_8k_yume_tsugi[0][0]
        + pattern_8k_yume_next[0][0]
        + pattern_8k_sho_tsugi[0][0]
        + pattern_8k_sho_next[0][0]
        + pattern_8k_shin_ya[0][0]
        + pattern_8k_green_pocket[0][0]
        + pattern_8k_yayoi_mamonaku[0][0]
        + pattern_8k_izu_mamonaku[0][0]
        + pattern_8k_izuchi_mamonaku[0][0]
        + pattern_8k_yume_mamonaku[0][0]
        + pattern_8k_sho_mamonaku[0][0]
        + pattern_8k_door_this[0][0]
        + pattern_8k_door_another[0][0]
        + pattern_8k_door_both[0][0]
        + pattern_8k_yayoi_jp[0][0]
        + pattern_8k_yayoi_en[0][0]
        + pattern_8k_izu_jp[0][0]
        + pattern_8k_izu_en[0][0]
        + pattern_8k_izuchi_jp[0][0]
        + pattern_8k_izuchi_en[0][0]
        );
    
    while(1) {
        // 行選択
        scan++; // 一行進む
        if(scan == 17+0) { // 16行目の次
            SER = LO; // 点灯
            scan = 1; // 1行目に戻る
//            round++; // スキャンが1周した
//            t = timer.read_ms();
            t += 1;
        } else if(scan == 2) { // 2行目
            SER = HI; // 消灯
        }
        
        // 表示パターン送り込み
//        int t = scroll;
        for(int i=0; i<4*11; i++){ // iは最大で～*11文字
        if(true) {
            if(t/8/speed*2 < 4*(166+11)) {
                unsigned char p;
                char y = scan-1;
                char x = 4*11-1-i%(4*11);
                if(t/8/speed*2 <= i) {
                    p  = (unsigned char)~0b00000000                     >> (  (t/speed)%8);
                } else if(t/8/speed*2 <= 4*166+i) {
                    p  = (unsigned char)~pattern_8k_green_pocket[y][x+(t/8/speed*2-4*11)]   >> (  (t/speed)%8);
                } else {
                    p  = (unsigned char)~0b00000000                     >> (  (t/speed)%8);
                }
                if(t/8/speed*2 <= i-4) {
                    p += (unsigned char)~0b00000000                     << (8-(t/speed)%8);
                } else if(t/8/speed*2 <= 4*166+i-4) {
                    p += (unsigned char)~pattern_8k_green_pocket[y][x+(t/8/speed*2)+2-4*11] << (8-(t/speed)%8);
                } else {
                    p += (unsigned char)~0b00000000                     << (8-(t/speed)%8);
                }
                spi.write(p);
            } else {
                spi.write((unsigned char)~pattern5[scan-1][4*11-1-i%(4*11)]);
//                spi.write((unsigned char)~0b00000000); //消灯
            }
        }
//            spi.write((unsigned char)~pattern2[scan-1][4*11-1-i%(4*11)]);
//spi.write(0);
//spi.write(0b10101010);
//spi.write(0b11111111);
        }
        
        // スクロール
//        if(round > speed) { // スクロール速度
//            scroll++; // 1ドットスクロールする
//            round = 0; // スキャン周回カウントリセット
//        }
//        if(scroll > 200) { // スクロール幅
//            scroll = 0; // スクロール数リセット
//        }

        wait_us(10);
        RCK = LO;
        CLK = LO;
//        G = HI; // 消灯
        wait_us(10);
        RCK = HI;
        CLK = HI;
        
        // ここまでの処理時間が長いほど明るくなる
//        while(timer.read_us()<0) { // 数字のぶんだけ暗くする
//            wait_us(10);
//        }

        if(!BUTTON) G = LO; // ボタン押せば点灯
        
        // ダイナミック点灯のパルス幅を決める
//        while(timer.read_us()<100) { // 100*2500でゆっくり
//            wait_us(10);
//        }
//        pc.printf("%d\r\n", timer.read_us());
//        pc.printf("%d\r\n", round/100);
    }
}
