#include "mbed.h"
#include "GpsInterface.h"

Serial debug(USBTX, USBRX);
Timer timer;

SirfStarIII::GpsInterface gps(p13,p14);

int main() {
    debug.baud(115200);
    debug.printf("GPS TEST FIRMWARE\r\n");

    gps.initialise(SirfStarIII::NMEA, 4800);
    
    timer.start();
    
    while (1) {
        gps.update();

        if (timer.read_ms() > 1000) {
            timer.reset();
            debug.printf("%02d/%02d/%d %02d:%02d:%02d - %f, %f\r\n", gps._time.day,  gps._time.month, gps._time.year, gps._time.hours, gps._time.minutes, gps._time.seconds, gps._position.latitude._dec_degrees, gps._position.longitude._dec_degrees);
        }
        
    }
}
