#ifndef SIRF_PROTOCOL_NMEA_PACKETS
#define SIRF_PROTOCOL_NMEA_PACKETS

#include <string>
#include <vector>
#include <map>

namespace SirfStarIII {

namespace NMEAPacket {

enum PacketNames{
    ID_GGA, //Time, position and fix type data.
    ID_GLL, //Latitude, longitude, UTC time of position fix and status.
    ID_GSA, //GPS receiver operating mode, satellites used in the position solution, and DOP values.
    ID_GSV, //The number of GPS satellites in view satellite ID numbers, elevation, azimuth, and SNR values.
    ID_MSS, //Signal-to-noise ratio, signal strength, frequency, and bit rate from a radio-beacon receiver.
    ID_RMC, //Time, date, position, course and speed data.
    ID_VTG, //Course and speed information relative to the ground.
    ID_ZDA, //PPS timing message (synchronized to PPS).
    ID_150 //OK to send message.
};

class NMEAPacket {
public:
    NMEAPacket() {}
    virtual ~NMEAPacket() {}

    std::vector<std::string> _fields;
    
    void interpretData(SimpleSerialProtocol::Packet* packet) {
        std::string raw_data( (char *) packet->_data);
        std::string  temp;
        while (raw_data.find(",", 0) != std::string::npos) {
            size_t  pos = raw_data.find(",", 0);
            temp = raw_data.substr(0, pos);
            raw_data.erase(0, pos + 1);
            if (temp.size() == 0) {
                temp = "0";
            }
            _fields.push_back(temp);
        }
        _fields.push_back(raw_data);
    }

};

}

}

#endif