#ifndef SIRF_PROTOCOL
#define SIRF_PROTOCOL

#include "mbed.h"
#include "MODSERIAL.h"
#include "Protocol.h"
#include "BinaryPackets.h"
#include "NmeaPackets.h"

namespace SirfStarIII {

enum ProtocolMode {
    BINARY,
    NMEA    
};

class SirfStarIII : public SimpleSerialProtocol::Protocol {
public:
    SirfStarIII(PinName tx, PinName rx);
    virtual ~SirfStarIII();
    
    virtual void initialise();
    virtual void initialise(ProtocolMode mode, uint32_t baud_rate);
    virtual void receive();
    virtual void sendPacket(SimpleSerialProtocol::Packet* packet);
    
    void receiveBinary();
    uint16_t checksumBinary(uint8_t* packet, uint16_t packet_size);
    void sendBinaryPacket(SimpleSerialProtocol::Packet* packet);
    
    void receiveNMEA();
    uint8_t checksumNMEA(const char * command);
    void sendNMEAPacket(SimpleSerialProtocol::Packet* packet);
    
    void selectMode(ProtocolMode mode, uint32_t baud, bool find_baud = false);
    void selectBaud(uint32_t baud);
    
    void NMEAChangeBaud(uint32_t baud_rate);
    void BinaryChangeBaud(uint32_t baud_rate);
        
    ProtocolMode _mode;
};

}

#endif