#ifndef SIRF_PROTOCOL_GPS_INTERFACE
#define SIRF_PROTOCOL_GPS_INTERFACE

#include "sIRFstarIII.h"

namespace SirfStarIII {

class GpsInterface : public SirfStarIII {
public:
    GpsInterface(PinName tx, PinName rx);
    virtual ~GpsInterface() {}

    void onReceiveGeodeticNavigationData(SimpleSerialProtocol::Packet* packet);
    void onReceiveMeasuredTrackingData(SimpleSerialProtocol::Packet* packet);
    void onReceiveDGPSStatus(SimpleSerialProtocol::Packet* packet);
    void onReceiveRMC(SimpleSerialProtocol::Packet* packet);
    
    class Coordinate {
    public:
        Coordinate() {
            _gps_format = 0;
            _dec_degrees = 0;
            _degrees = 0;
            _minutes = 0;
            _seconds = 0;
        }
        ~Coordinate() {}
        float _gps_format;
        char _indicator;
        float _dec_degrees;
        uint16_t _degrees;
        uint16_t _minutes;
        float _seconds;

        void set(float raw, char indicator) {
            if(indicator == '0')return;
            if (raw < 10000) {
                raw = raw / 100;
            } else {
                raw = raw / 1000;
            }
            _gps_format = raw;
            _degrees = static_cast<uint16_t>(raw);
            raw = (raw - _degrees)*100;
            _minutes = static_cast<uint16_t>(raw);
            _seconds = 60 * (raw - _minutes);
            _dec_degrees = _degrees + (float)((float)_minutes/60) + (float)(_seconds/3600);
            _indicator = indicator;
            if(indicator == 'S' || indicator == 'W') _dec_degrees *= -1;
        }

        void operator= (float param) {
           _dec_degrees = param;
        }
        
    };

    struct FixData {
        enum Type {
            NoFix,
            Fixed,
            DifFix,
            Reserved1,
            Reserved2,
            Reserved3,
            DeadReckFix
        };
        uint8_t valid;
        uint8_t fix_type;
        uint8_t sats;
    } _fix;

    struct Position {
        Coordinate longitude;
        Coordinate latitude;
        float altitude;
        float speed;
        float course;
        uint8_t fix_type;
    } _position;

    struct Time {
        uint16_t year;
        uint8_t month;
        uint8_t day;
        uint8_t hours;
        uint8_t minutes;
        uint8_t seconds;
    } _time;

};

}

#endif