#include "GpsInterface.h"

namespace SirfStarIII {

GpsInterface::GpsInterface(PinName tx, PinName rx) : SirfStarIII(tx, rx) {
    receiveCallback(BinaryPacket::ID_GeodeticNavigationData, this,  &GpsInterface::onReceiveGeodeticNavigationData);
    receiveCallback(BinaryPacket::ID_MeasuredTrackingData, this,  &GpsInterface::onReceiveMeasuredTrackingData);
    receiveCallback(BinaryPacket::ID_DGPSStatus, this,  &GpsInterface::onReceiveDGPSStatus);
    receiveCallback(NMEAPacket::ID_RMC, this,  &GpsInterface::onReceiveRMC);
}

void GpsInterface::onReceiveGeodeticNavigationData(SimpleSerialProtocol::Packet* packet) {
    if(!packet)return;
    
    if (packet->_valid) {
        BinaryPacket::GeodeticNavigationData::Interface* interface = packet->interpretData<BinaryPacket::GeodeticNavigationData::Interface>();
        if (interface) {
            BinaryPacket::GeodeticNavigationData::swapByteOrder(interface);
            _fix.sats =  interface->satalites_in_fix;
            _position.longitude = (((float)interface->longitude)/10000000);
            _position.latitude = (((float)interface->latitude)/10000000);

            _time.year = interface->year;
            _time.month = interface->month;
            _time.day = interface->day;
            _time.hours = interface->hour;
            _time.minutes = interface->minute;
            _time.seconds = interface->second/1000;
        }
    }
    return;
}

void GpsInterface::onReceiveMeasuredTrackingData(SimpleSerialProtocol::Packet* packet) {
    if(!packet)return;
    
    if (packet->_valid) {
        BinaryPacket::MeasuredTrackingData::Interface* interface = packet->interpretData<BinaryPacket::MeasuredTrackingData::Interface>();
        if (interface) {

        }
    }
    return;
}

void GpsInterface::onReceiveDGPSStatus(SimpleSerialProtocol::Packet* packet) {
    if(!packet)return;
    
    if (packet->_valid) {
        BinaryPacket::DGPSStatus::Interface* interface = packet->interpretData<BinaryPacket::DGPSStatus::Interface>();
        if (interface) {

        }
    }
    return;
}

void GpsInterface::onReceiveRMC(SimpleSerialProtocol::Packet* packet) {
    if(!packet)return;
    
    NMEAPacket::NMEAPacket nmeaPacket;
    if (packet->_valid) {
        nmeaPacket.interpretData(packet);
        float time = atof(nmeaPacket._fields[1].c_str());
        _time.seconds = (int)time % 100;
        _time.minutes = (int)(time / 100)%100;
        _time.hours =  (int)(time / 10000);

        //   2 Time Status
        _position.latitude.set(atof(nmeaPacket._fields[3].c_str()), (char)nmeaPacket._fields[4].c_str()[0]);
        _position.longitude.set(atof(nmeaPacket._fields[5].c_str()), (char)nmeaPacket._fields[6].c_str()[0]);
        _position.speed = atof(nmeaPacket._fields[7].c_str());
        _position.course = atof(nmeaPacket._fields[8].c_str());

        uint32_t date = atoi(nmeaPacket._fields[9].c_str());
        _time.year = 2000 + (date % 100);
        date /= 100;
        _time.month = date % 100;
        _time.day = date / 100;

        // 10   magnetic variation
        // 11   mode
    }

    return;
}

}