#include "TestProtocol.h"

void TestProtocol::onEchoPacket(SimpleSerialProtocol::Protocol* comms, SimpleSerialProtocol::Packet* packet){
    if(!packet)return;
    if (packet->_valid) {
        EchoPacket::Interface* interface = packet->interpretData<EchoPacket::Interface>();
        if (interface) {
            temp = interface->data;
            temp1 = interface->datashort;
            temp2 = interface->dataint;
            temp3 = interface->datafloat;
            
            //we can use the Protocol pointer to send a response from the callback
            EchoPacket echoMessage; // initialise a packet to send
            echoMessage.interface.data = temp;
            echoMessage.interface.datashort = temp1;
            echoMessage.interface.dataint = temp2;
            echoMessage.interface.datafloat = temp3;
            echoMessage.buildData<EchoPacket::Interface>(&echoMessage.interface);
            comms->send(&echoMessage); //send the packet (async)
        }
    }
    return;
}