#include "mbed.h"
#include "Protocol.h"
#include "TestProtocol.h"

//valid test packet bytes
//
// 255 127 // packet start 2 bytes 
// 12 // payload size 1 byte
// 0 0 0 0 0 0 0 0 0 0 0 0 // payload data
// 16 // checksum 1 byte

//checksum calculation
//
//    uint8_t tmp_checksum = 16;
//    for (int i = 0; i < packet_size; i++) {
//        tmp_checksum ^= packet[i];
//    }
//    return tmp_checksum;

TestProtocol testProtocol;
SimpleSerialProtocol::Protocol comms(USBTX, USBRX, LED1);

//the main loop
int main() { 
    comms.initialise(115200);
    comms.receiveCallback(1, &testProtocol, &TestProtocol::onEchoPacket);
        
    while (1) {
        comms.update();
    }
}
