#ifndef _TEST_PROTOCOL_H
#define _TEST_PROTOCOL_H

#include <mbed.h>
#include <SimpleSerialProtocol/Protocol.h>

//class will receive a packet and echo it back out
class TestProtocol {
public:
    TestProtocol() {
        temp = 0;
        temp1 = 0;
        temp2 = 0;
        temp3 = 0.0f;
    }
    virtual ~TestProtocol() {};
    void onEchoPacket(SimpleSerialProtocol::Protocol* comms, SimpleSerialProtocol::Packet* packet);

    class EchoPacket : public SimpleSerialProtocol::Packet {
    public:
        EchoPacket() {}
        virtual ~EchoPacket() {}
        
#pragma pack(push, 1) //must pack the structure to byte boundary for raw recast to work reliably
                      //this is used in Packet::interpretData and used to validate the packet
        struct Interface {
            Interface() {
                type = 1; // initialise the type
            }
            uint8_t type;
            uint8_t data;
            uint16_t datashort;
            uint32_t dataint;
            float datafloat;
        } interface;
#pragma pack(pop)

    };

    uint8_t temp;
    uint16_t temp1;
    uint32_t temp2;
    float temp3;
};

#endif