#ifndef RINGBUFFER
#define RINGBUFFER
namespace SimpleSerialProtocol {

class RingBuffer {
public:
    RingBuffer() {
        _read_index = 0;
        _write_index = 0;
        _size = 256;
        _buffer = new uint8_t[_size];
        _dropped_bytes = 0;
    }
    RingBuffer(uint16_t capacity) {
        _read_index = 0;
        _write_index = 0;
        _size = capacity;
        _buffer = new uint8_t[_size];
        _dropped_bytes = 0;
    }
    ~RingBuffer() {
        delete[] _buffer;
    }

    uint16_t size() {
        return _size;
    }

    uint16_t available() {
        if (_write_index < _read_index) {
            return (_write_index + size()) - _read_index;
        } else {
            return _write_index - _read_index;
        }
    }

    bool write(uint8_t byte) {
        if(available() < (size() -1) ){
            _buffer[_write_index++] = byte;
            _write_index %= size();
            return true;
        } else {
            _buffer[_write_index++] = byte;
            _write_index %= size();
            
            ++_read_index;
            _read_index %= size();
            
            _dropped_bytes++;
            return true;
        }
    }

    uint8_t read() {
        if(available()){
            uint8_t value = _buffer[_read_index++];
            _read_index %= size();
            return value;
        }
        return 0;
    }
    
    uint32_t droppedBytes() {
        return _dropped_bytes;
    }

private:
    uint16_t _read_index;
    uint16_t _write_index;
    uint8_t* _buffer;
    uint16_t _size;
    uint32_t _dropped_bytes;
};

}
#endif