/*
    Copyright (c) 2011 Andy Kirkham

    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
    
    Modified for use with SimpleSerialProtocol by Christopher Pepper
*/

#ifndef AJK_FPOINTER_H
#define AJK_FPOINTER_H

namespace SimpleSerialProtocol {

class FPointerDummy;
class Packet;
class Protocol;

typedef Packet* Packet_ptr;
typedef Protocol* Protocol_ptr;

class FPointer {

protected:

    //! C callback function pointer.
    void (*c_callback)(Protocol_ptr, Packet_ptr);

    //! C++ callback object/method pointer (the object part).
    FPointerDummy  *obj_callback;

    //! C++ callback object/method pointer (the method part).
    void (FPointerDummy::*method_callback)(Protocol_ptr, Packet_ptr);

public:

    /** Constructor
     */
    FPointer() {
        c_callback      = NULL;
        obj_callback    = NULL;
        method_callback = NULL;
    }


    void attach(void (*function)(Protocol_ptr, Packet_ptr) = 0) {
        c_callback = function;
    }

    template<class T>
    void attach(T* item, void (T::*method)(Packet_ptr)) {
        obj_callback    = (FPointerDummy *)item;
        method_callback = (void (FPointerDummy::*)(Protocol_ptr, Packet_ptr))method;
    }

    void call(Protocol_ptr comms, Packet_ptr arg) {
        if (c_callback != NULL) {
            return (*c_callback)(comms, arg);
        } else {
            if (obj_callback  != NULL && method_callback != NULL) {
                (obj_callback->*method_callback)(comms, arg);
                return;
            }
        }
        return;
    }

    void call(void) {
        if (c_callback != NULL) {
            (*c_callback)((Protocol_ptr)NULL, (Packet_ptr)NULL);
            return;
        } else {
            if (obj_callback  != NULL && method_callback != NULL) {
                (obj_callback->*method_callback)((Protocol_ptr)NULL, (Packet_ptr)NULL);
                return;
            }
        }
        return;
    }
};

};


#endif
