#ifndef _SFT_PROTOCOL_H
#define _SFT_PROTOCOL_H

#include <mbed.h>
#include <SimpleSerialProtocol/Protocol.h>

//class will receive a packet and echo it back out
class SFTProtocol {
public:
    SFTProtocol() { //LED1 to 4 for a status led, NC to disable        
        transfer_in_progress = false;
        chunks_total = 0;
        chunks_last = 0;
        packet_retry_attempts = 0;
        fp = 0;
    }
    virtual ~SFTProtocol() {};
    
    //the callbacks and packet sending methods
    virtual void update(SimpleSerialProtocol::Protocol* comms);
    void onFileStart(SimpleSerialProtocol::Protocol* comms, SimpleSerialProtocol::Packet* packet);
    void ack(SimpleSerialProtocol::Protocol* comms, uint8_t ack_type);
    void onFileStream(SimpleSerialProtocol::Protocol* comms, SimpleSerialProtocol::Packet* packet);
    
    //variables to control the transfer and save the file
    bool transfer_in_progress;
    int chunks_total;
    int chunks_last;
    Timer last_chunk_timer;
    int packet_retry_attempts;
    FILE *fp;
    
    
    //This packed is used to start a file transfer it is sent by the client
    //once received a file is created and an ack packet sent to start the file stream
    class FileStartPacket : public SimpleSerialProtocol::Packet {
    public:
        FileStartPacket() {}
        virtual ~FileStartPacket() {}
        
#pragma pack(push, 1) //must pack the structure to byte boundary for raw recast to work reliably
        struct Interface {
            Interface() {
                type = 1; // initialise the type
            }
            uint8_t type;
            uint8_t name[9];
            uint8_t ext[4];
            uint32_t chunks;
        } interface;
#pragma pack(pop)
        
    };
    
    //A very simple Ack packet used to inform the client that we need more data, and other commands based on the ack_type value
    class AckFileStartPacket : public SimpleSerialProtocol::Packet {
    public:
        AckFileStartPacket() {}
        virtual ~AckFileStartPacket() {}
        
#pragma pack(push, 1) //must pack the structure to byte boundary for raw recast to work reliably
        struct Interface {
            Interface() {
                type = 2; // initialise the type
            }
            uint8_t type;
            uint8_t ack_type;
        } interface;
#pragma pack(pop)
        
    };
    
    //This is the packet used to send the file data 128 bytes at a time
    //its posible to send upto 256 bytes but this was causing my xbees to drop a lot of data
    class FileStreamPacket : public SimpleSerialProtocol::Packet {
    public:
        FileStreamPacket() { }
        virtual ~FileStreamPacket() {}
        
#pragma pack(push, 1) //must pack the structure to byte boundary for raw recast to work reliably
        struct Interface {
            Interface() {
                type = 3; // initialise the type
            }
            uint8_t type;
            uint16_t chunk;
            uint8_t length;
            uint8_t data[128];
            
        } interface;
#pragma pack(pop)
        
    };
 
};

#endif