#include "mbed.h"
#include "SerialFileTransfer.h"

//Create an instance of the SimpleSerialProtocol on a Serial port, optionaly choose a status led
SimpleSerialProtocol::Protocol comms(USBTX, USBRX, LED1);

Serial debug(p13,p14);

SFTProtocol fileAcceptor;

int main() {
    //initialise the comm port at 155200 baud
    comms.initialise(115200);
    //listen for packets of type 1 and relay the data to the onFileStart callback in SFTProtocol
    comms.receiveCallback(1, &fileAcceptor, &SFTProtocol::onFileStart);
    //listen for packets of type 3 and relay
    comms.receiveCallback(3, &fileAcceptor, &SFTProtocol::onFileStream);
    
    debug.baud(115200);
    debug.printf("Debug Terminal:\r\n");
    
    while(true){
        //the protocol needs constant updates to process packets and forward the data
        comms.update();
        
        //the SFTProtocol is updated so it can timeout, and request packet resends, 
        fileAcceptor.update(&comms);
    }
}