#include "mbed.h"
#include "C12832.h"

C12832 lcd(p5, p7, p6, p8, p11);

InterruptIn center(p14);
Timer timer;
Ticker ticker;

DigitalOut green(p24);
DigitalOut red(p23);
AnalogIn seed(p16);

int allOff();
int startTimer();
int startMeasurement();
int finishMeasurement();
void tick();

volatile unsigned int newEvent =0; 
volatile unsigned int event=0, state=0;

unsigned int rnd = 0;
int rndCounter = 0;

unsigned char nextstate_tab[1][4]=  { 1, 2, 3, 0 };

int(*action[1][4])()= { allOff, startTimer, startMeasurement, finishMeasurement }; 

int allOff()
{
    ticker.detach();  
    green = 1;
    red  = 1;     
    return 0;
}

int startTimer()
{
    rnd = rand()%63; 
    
    if(rnd < 8)
    {
        while(rnd < 8) 
            rnd = rand()%63; 
    }
    
    green = 0;
    
    ticker.attach(&tick, 0.1); 
    center.disable_irq();
    return 0;   
}        

int startMeasurement()
{
    timer.start();
    ticker.detach();
    return 0;
} 

int finishMeasurement()
{
    timer.stop();
    rndCounter = 0;
    lcd.locate(0, 20);
    lcd.printf("Zeit: %f", timer.read());
    timer.reset();
    newEvent = 1;
    return 0;    
}

void buttonPressed()
{
    newEvent = 1;
}

void tick()
{
    rndCounter++;
    
    if(rndCounter == rnd)
    {
        green = 1;
        newEvent = 1; 
        center.enable_irq();   
    }
}

int main() {
    
    center.rise(&buttonPressed);
    
    lcd.cls();
    lcd.locate(0, 0);
    lcd.printf("Reaktionstester");
    
    green = 1;
    red  = 1;
    
    newEvent = 0;
    state=0; 
    event=0;
    
    srand(seed.read_u16());
    
    while(1) {
        
        if (newEvent)
        {
            newEvent =0;
            (*action[event][state])(); 
            state=nextstate_tab[event][state];
        }

    }
}
