// A program which test the PWMAverage library internally: just connect pins 23, 29 and 30 short and check it on the terminal

#include "mbed.h"
#include "PWMAverage.h"

DigitalOut myled(LED1);
DigitalIn button (p17);
PwmOut out(p23);
AnalogIn in(p19);

float val;
float increment = 0.01;

PWMAverage pa(p29,p30);
Timer tmr;

int main()
{
    button.mode(PullDown);
    
    out.period(0.0001);
    printf("Ready\n\r");
    val = 0;
    while(1)
    {
        
        val += increment;
        
        if(val >= 1) return;
        
        out = val;    
        
        pa.reset();
        pa.start();
        tmr.start();
        myled=1;
    
        wait(0.5);
        
        pa.stop();
        tmr.stop();
        myled=0;
   
        printf("PWMAverage read: %.4f, PWM wrote:%.4f\n\r",pa.read(),val);
        wait(0.1);
    }

}
