#include "mbed.h"
#include "sinelookup.h"
#include "TLV320.h"
#include "I2S.h"

#define SAMPLERATE 48000


TLV320 codec(p9, p10);
I2S i2s(I2S_TRANSMIT, p5, p6, p7);

AnalogIn aIn(p19);
AnalogIn vol(p20);

float phase_l;
float phase_r;
int minibuf[16];
float skipper;
float volume;
float phase_kill;


extern "C" void HardFault_Handler()
{
    error("Hard Fault!\n");
}


void play(void)
{   
    int to_write = i2s.max_fifo_points() - (i2s.fifo_points());
    for(int i = 0; i < to_write; i+=2) {
        minibuf[i] = int(float(sine16lookup[int(phase_l)])*volume);
        //minibuf[i] = int(sine16lookup[int(phase_l)]);
        minibuf[i+1] = int(float(sine16lookup[int(phase_r)])*volume);
        phase_l+=skipper;
        phase_r = phase_l + phase_kill;
        while(phase_l >= SINE16LENGTH) {
            phase_l -= SINE16LENGTH;
        }
        
        while(phase_r >= SINE16LENGTH) {
            phase_r -= SINE16LENGTH;
        }
        while(phase_r< 0) phase_r += SINE16LENGTH;
    }
    i2s.write(minibuf, to_write);
}

/* main */
int main()
{
    skipper = (aIn*49)+1;
    
    codec.power(true);
    codec.frequency(SAMPLERATE);
    codec.wordsize(16);  
    codec.master(false);
    codec.headphone_volume(0.5);
    codec.start();
    
    i2s.frequency(SAMPLERATE);
    i2s.wordsize(16);
    i2s.stereomono(I2S_STEREO);
    i2s.masterslave(I2S_MASTER);
    i2s.attach(&play);
    i2s.start();
    
    while(1)
    {
        skipper = (aIn*30)+1;

        volume = 1;
        phase_kill = (vol-0.5)*400;

        //printf("Skipper:%f, %i, %i\n\r",skipper, to_write,i2s.fifo_level());
        
        /*if(flag)
        {
        printf(".");
        flag = false;
        }*/
    }

}