#include "mbed.h"
#include "HBridge.h"
#include "ActionCue.h"
#include "WavPlayer.h"
#include "MSCFileSystem.h"

#define TICK_TIME 0.05

MSCFileSystem msc("msc"); // Mount flash drive under the name "msc"
LocalFileSystem local("local");
WavPlayer player;

HBridge hbridge(p18,p15,p22);
DigitalIn button(p16);
AnalogIn pot1(p19);

HBridge hbridge2(p28,p27,p21);
DigitalIn button2(p17);
AnalogIn pot2(p20);

DigitalOut led1(LED1);
DigitalOut led2(LED2);

ActionCue cue;

Ticker ticks;

float c_time;

int audioNumber = 0;
float audioTime = 0;

extern "C" void HardFault_Handler()
{
    error("Hard Fault!\n");
}


enum actionTypes
{
    Null = -1,
    Debug = 0,
    c_led1,
    c_led2,
    motor1,
    motor2,
    play
};

void onTick()
{
    while(cue.numActionsStored() > 0)
    {
        Action act = cue.nextAction();
        if(act.actionTime <= c_time)
        {
            cue.usedFirst();
            //printf("Action. Time: %f Type: %i\n\r",act.actionTime, act.actionType);
            switch(act.actionType)
            {
                case Debug:
                    printf("Action. Time: %f Type: %i\n\r",act.actionTime, act.actionType);
                    break;
                case c_led1:
                    led1 = bool(act.actionInt);
                    break;
                case c_led2:
                    led2 = bool(act.actionInt);
                    break;
                case motor1:
                    hbridge.speed(act.actionFloat);
                    hbridge.power(true);
                    break;
                case motor2:
                    hbridge2.speed(act.actionFloat);
                    hbridge2.power(true);
                    break;
                case play:
                    audioNumber = act.actionInt;
                    audioTime = act.actionFloat;
                    break;
                default:
                    break;
            }
        }
        else
        {
            break;
        }
    }
    c_time += float(TICK_TIME);
}

actionTypes parseType(char in[4])
{
         if(strcmp(in, "NULL") == 0) return Null;
    else if(strcmp(in, "DEBG") == 0) return Debug;
    else if(strcmp(in, "LED1") == 0) return c_led1;
    else if(strcmp(in, "LED2") == 0) return c_led2;
    else if(strcmp(in, "MTR1") == 0) return motor1;
    else if(strcmp(in, "MTR2") == 0) return motor2;
    else if(strcmp(in, "PLAY") == 0) return play;
    else return Null;
}

int main() {
    button.mode(PullDown);
    ticks.attach(&onTick,TICK_TIME);
    c_time = 0;
    int returned = 4;
    printf("Opening the file \n\r");
    FILE* sequence = fopen("/local/seq.txt","r");
    
    if(sequence != NULL)
    {
        printf("File opened\n\r");
        while(returned >= 2)
        {
            float temptime = 0;
            char code[5];
            int tempint = 0;
            float tempfloat = 0;
            returned = fscanf(sequence, "%f %4s %d %f", &temptime, &code, &tempint, &tempfloat);

            if(returned >= 2)
            {
                actionTypes temptype = parseType(code);
                Action act(temptime, temptype, tempint, tempfloat);
                cue.addAction(act);
                printf("Read Action. Time: %f Type: %i\n\r",act.actionTime, act.actionType);

            }
        }
    }
    
    cue.orderCue();
    
    while(1)
    {
        if(audioNumber != 0)
        {
            char filename[16];
            sprintf(filename, "/msc/%2.2i.wav",audioNumber);
            printf("Playin': %s\n\r",filename);
            FILE* file = fopen(filename, "r");
            player.open(&file);
            if(audioTime == 0) player.play();
            else player.play(audioTime);
            fclose(file);
            audioNumber = 0;
        }
    }
    

}
