#include "ActionCue.h"
#include "mbed.h"

#define ACTIONCUE_ORDERLIMIT 100

ActionCue::ActionCue()
{
    start = 0;
    finish = 0;
    numStored = 0;
    for(int i = 0; i < ACTIONCUE_SIZE; i++)
    {
        cue[i] = Action();
    }
}
    
void ActionCue::addAction(Action action_to_add)
{
    cue[finish] = action_to_add;
    finish++;
    numStored++;
    if(finish >= start && numStored > ACTIONCUE_SIZE)
    {
        start++;
    }
    finish = wrap(finish);
    start  = wrap(start);
}

int ActionCue::numActionsStored()
{
    return numStored;
}

Action ActionCue::nextAction()
{
    return cue[start];
}

void ActionCue::usedFirst()
{
    start++;
    numStored--;
    finish = wrap(finish);
    start  = wrap(start);
}

Action ActionCue::actionAt(float time)
{
    for(int i = 0; i < ACTIONCUE_SIZE; i++)
    {
        if(cue[i].actionTime == time) return cue[i];
    }
    return Action();
}

void ActionCue::orderCue()
{
    int swapcount = 1;
    int runcount = 0;
    Action temp;
    while((swapcount > 0) && runcount < ACTIONCUE_ORDERLIMIT)
    {   
        swapcount = 0;
        for(int i = 0; i < (numStored - 1); i++)
        {
            if(cue[wrap(i+1+start)].actionTime <= cue[wrap(i+start)].actionTime)
            {
                temp = cue[wrap(i+start)];
                cue[wrap(i+start)] = cue[wrap(i+1+start)];
                cue[wrap(i+1+start)] = temp;
                swapcount++;
            }
        }
        runcount++;
    }
    //printf("Ran: %i\n\r",runcount);
}

int ActionCue::wrap(int in)
{
    while(in >= ACTIONCUE_SIZE)
    {
        in -= ACTIONCUE_SIZE;
    }
    return in;
}







