// Measure and print the average duty cycle of a signal connected to p29 and p30 (together) while the button (p16) is pulled high

#include "mbed.h"
#include "PWMAverage.h"

DigitalOut myled(LED1);

PWMAverage pa(p29,p30);

DigitalIn button (p16);

Timer tmr;

int main()
{
    button.mode(PullDown);
    while(1)
    {
        pa.reset();
    
        while (!button) {}
        pa.start();
        tmr.start();
        myled=1;
    
        while (button) {}
        pa.stop();
        tmr.stop();
        myled=0;
    
        printf("Average dudy cycle over %d us was %.4f\n\r",tmr.read_us(),pa.read());
    }
}