#include "PWMAverage.h"

#define PWMA_PCLK 96000000


PWMAverage * PWMAverage::instance;


void PWMAverage::_tisr()
{
    //printf(".");
    int cr0 = LPC_TIM2->CR0;
    int cr1 = LPC_TIM2->CR1;
    
    LPC_TIM2->IR = 0x3F;
    
    LPC_TIM2->TCR = 3;
    LPC_TIM2->TCR = 1;
    
    //LPC_NVIC->ICPR0 |= (1<<3)
    
    if(!instance->starting)
    {
    instance->total += cr1 + 82;
    instance->totalup += cr0 + 82;
    instance->count_++;
    }
    else instance->starting = false;

    }

PWMAverage::PWMAverage(PinName cap0, PinName cap1)
{
    prescaler_point = 0x0;
    configure();
    stop();
    
    timeMult = (1/PWMA_PCLK)*(prescaler_point+1);
    timeDiv = PWMA_PCLK/(prescaler_point+1);
    instance = this;
}

void PWMAverage::reset()
{
    count_ = 0;
    total = 0;
    totalup = 0;
    LPC_TIM2->TCR = 2;
    LPC_TIM2->TCR = 0;
}

void PWMAverage::start()
{
    //reset();
    starting = true;
    enable(true);
    NVIC_EnableIRQ(TIMER2_IRQn);
}

void PWMAverage::stop()
{
    enable(false);
    NVIC_DisableIRQ(TIMER2_IRQn);
}

float PWMAverage::read()
{
    if(period() != 0) return float(avg_up()/period());
    else return 0;
}

double PWMAverage::avg_up()
{
    if(count_!= 0)    return (double(totalup)/timeDiv)/double(count_);
    else return 0;
    
}

float PWMAverage::avg_UP()
{
    if(count_!= 0)    return float((double(totalup)/timeDiv)/double(count_));
    else return 0;
}

double PWMAverage::avg_down()
{
    if(count_!= 0)    return (double(total-totalup)/timeDiv)/double(count_);
    else return 0;
}

double PWMAverage::period()
{
    if(count_!= 0)    return (double(total)/timeDiv)/double(count_);
    else return 0;
}

int PWMAverage::count()
{
    return count_;
}

void PWMAverage::enable(bool yn)
{
    LPC_TIM2->TCR = yn;
}

void PWMAverage::configure()
{
    //Power Periferal
    
    LPC_SC->PCONP |= (1<<22);
    
    //Setup Pins
    
    LPC_PINCON->PINSEL0 |= (0x3<<8);
    LPC_PINCON->PINSEL0 |= (0x3<<10);
    
    //Setup clock source
    
    LPC_SC->PCLKSEL1 |= (0x1<<12);

    //Setup PC
    
    LPC_TIM2->PR = prescaler_point;
    
    //Setup CAP0 - Store on fall
    
    LPC_TIM2->CCR |= 0x2; 
    
    //Setup CAP1 - Store on rise, interrupt
    
    LPC_TIM2->CCR |= 0x5<<3;
    
    //Setup IRQs
    NVIC_DisableIRQ(TIMER2_IRQn);
    NVIC_SetVector(TIMER2_IRQn, (uint32_t)&_tisr);
    NVIC_EnableIRQ(TIMER2_IRQn);
    //
}