#ifndef SHARPDIGIDIST100_H
#define SHARPDIGIDIST100_H

#include "mbed.h"

/** A class which interfaces with  a Sharp Digital Distance sensor (GP2Y0D810)
 *
 *  Example:
 * @code
 * 
 * @endcode
 *
 */

class SharpDigiDist100
{
public:

/** Create a sensor input
 *
 * @param pin The pin the output of the sensor is connected to
 */
 
SharpDigiDist100(PinName pin);

/** The enum which makes up the output
 * 
 */

enum Distance
{
    Near = 1,
    Mid,
    Far
};

/** Returns the distace as an enum
 *
 * @return The distance code: 1 is near, 2 is middle distance and 3 is far
 */
 
int getDistance();

/** Attaches a function which is called on distance change
 *
 * @param A pointer to a function with params/returns: void func(void)
 */

void attachOnChange(void (*ptr) (void));


protected:

InterruptIn intin;

DigitalIn pinin;

Timer timer1;

enum Distance current;

enum Distance last;

void onInt();

Timeout timeout;

void (*onChange) (void);

bool onChangeAttached;

//DigitalOut Debug;
};

#endif