/*Small library to debug and alert with a single LED
* Copyright (c) 2011 p07gbar
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
* THE SOFTWARE.
*
*/

#include "Flasher.h"

Flasher::Flasher(PinName pin, int startState):_led(pin)
{
    state = checkState(startState);
    flashTimes[0] = 10;
    flashTimes[1] = 10;
    flashTimes[2] = 2;
    flashTimes[3] = 1;
    flashTimes[4] = 0.3;
    flashbase.attach(this, &Flasher::tick, flashTimes[state]);
    active = true;    
    tick();
}

void Flasher::updateFlash(int statein)
{
    state = checkState(statein);
    flashbase.attach(this, &Flasher::tick, flashTimes[state]);
    tick();
}

int Flasher::getState()
{
    return state;
}

void Flasher::pauseFor(float time)
{
    active = false;
    forTime = time;
    returntoState = state;
    flashbase.detach();
    forbase.attach(this, &Flasher::timeout, time);
}

void Flasher::onFor(float time,int newState, int returnState = 0)
{
    active = true;
    state = checkState(newState);
    returntoState = checkState(returnState);
    flashbase.attach(this, &Flasher::tick, flashTimes[state]);
    forTime = time;
    forbase.attach(this, &Flasher::timeout, time);
}

void Flasher::pause()
{
    active = false;
    _led = 0;
    flashbase.detach();
    forbase.detach();
}

void Flasher::resume()
{
    active = true;
    flashbase.attach(this, &Flasher::tick, flashTimes[state]);
}

void Flasher::setFlashTime(int statein, float newTime)
{
    flashTimes[checkState(statein)] = newTime;
}

float Flasher::getFlashTime(int statein)
{
    float toRet = flashTimes[checkState(statein)];
    return toRet;
}

void Flasher::tick()
{
    if(active)
    {
        switch(state)
        {
            case 0:
            _led = 0;
            break;
            case 1:
            _led = 1;
            break;
            case 2:
            case 3:
            case 4:
            _led = !_led;
            break;
            default:
            _led = 0;
            break;
        }
    }
}

void Flasher::timeout()
{
    active = true;
    state = returntoState;
    forTime = 0;
    flashbase.attach(this, &Flasher::tick, flashTimes[state]);
    forbase.detach();
    tick();
}

int Flasher::checkState(int statein)
{
    if(statein > NUMSTATES || statein < 0)
    {
        return 0;
    }
    else 
    {
        return statein;
    }
}

Flasher& Flasher::operator= (int statein)
{
    updateFlash(statein);
    return *this;
}

Flasher::operator int()
{
    return state;
}
