#include "VNH5019Accel.h"

void VNH5019Accel::Interrupt()
{
    float MyRequestedSpeed = RequestedSpeed;
    if (CurrentSpeed != MyRequestedSpeed)
    {
        if (std::abs(CurrentSpeed-MyRequestedSpeed) < VNH5019ChangePerTick)
            CurrentSpeed = MyRequestedSpeed;
        else if (MyRequestedSpeed > CurrentSpeed)
            CurrentSpeed += VNH5019ChangePerTick;
        else
            CurrentSpeed -= VNH5019ChangePerTick;
        Driver.speed(CurrentSpeed);
    }
    else
    {
        float MyRequestedBrake = RequestedBrake;
        if (CurrentBrake != MyRequestedBrake)
        {
            if (std::abs(CurrentBrake-MyRequestedBrake) < VNH5019BrakeChangePerTick)
                CurrentBrake = MyRequestedBrake;
            else if (MyRequestedBrake > CurrentBrake)
                CurrentBrake += VNH5019BrakeChangePerTick;
          else
                CurrentBrake -= VNH5019BrakeChangePerTick;
            Driver.brake(CurrentBrake);
        }
    }
}
