#include "Enemy.h"
#include "mbed.h"
#include <stdlib.h>

Enemy::Enemy() {}

int Enemy::get_x() {
    return _x;
}

int Enemy::get_y() {
    return _y;
}

void Enemy::set_x(int x) {
    _x = x;
}

void Enemy::set_y(int y) {
    _y = y;
}

void Enemy::add_x(int x) {
    _x += x;
}

void Enemy::add_y(int y) {
    _y += y;
}

void Enemy::init() {
    // function to randomly initialize position of each enemy god
    int rrandom = rand()%64;
    set_x(40);
    set_y(34);
    
}
void Enemy::draw(N5110 &lcd, int input) {

    const int look_left[12][10] =   {
    { 0,0,1,1,1,0,0,0,0,0 },
    { 0,0,1,1,1,0,0,0,0,0 },
    { 0,0,0,1,1,1,1,1,1,0 },
    { 0,0,1,0,1,1,0,0,1,0 },
    { 1,1,1,0,1,1,0,1,1,1 },
    { 0,0,0,0,1,1,0,0,1,0 },
    { 0,0,0,1,1,1,1,0,0,0 },
    { 0,0,1,1,0,0,1,1,0,0 },
    { 0,1,1,0,0,0,1,1,0,0 },
    { 0,0,1,1,0,0,0,1,1,0 },
    { 0,0,0,1,0,0,0,0,1,0 },
    { 0,1,1,1,0,0,0,1,1,0 },
    };

    const int look_right[12][10] =   {
    { 0,0,0,0,0,1,1,1,0,0 },
    { 0,0,0,0,0,1,1,1,0,0 },
    { 0,0,0,1,1,1,1,0,0,0 },
    { 0,0,1,1,1,1,1,0,1,0 },
    { 0,1,1,0,1,1,0,1,1,1 },
    { 0,0,0,0,1,1,0,0,1,0 },
    { 0,0,0,1,1,1,1,0,0,0 },
    { 0,0,1,1,0,0,1,1,0,0 },
    { 0,0,1,1,0,0,0,1,1,0 },
    { 0,1,1,0,0,0,1,1,0,0 },
    { 0,1,0,0,0,1,1,0,0,0 },
    { 0,1,1,0,1,1,1,1,0,0 },
    };

    if (input == 1) {
        lcd.drawSprite(_x,_y,12,10,(int *)look_right);
        }
    else {
        lcd.drawSprite(_x,_y,12,10,(int *)look_left);
        }
        
}
// ************************************************************************


void Enemy::move_left(N5110 &lcd){
    const int run_left[12][10] =   {
    { 0,0,1,1,1,0,0,0,0,0 },
    { 0,0,1,1,1,0,0,0,0,0 },
    { 0,0,0,1,1,1,1,1,1,0 },
    { 0,0,1,0,1,1,0,0,1,0 },
    { 1,1,1,0,1,1,0,1,1,1 },
    { 0,0,0,0,1,1,0,0,1,0 },
    { 0,0,0,1,1,1,1,0,0,0 },
    { 0,0,1,1,0,0,1,1,0,0 },
    { 0,1,1,0,0,0,1,1,1,1 },
    { 0,0,1,1,0,0,0,0,0,0 },
    { 0,0,0,1,1,0,0,0,0,0 },
    { 0,0,0,0,1,1,0,0,0,0 },
    };
    
    const int midrun_left[12][10] =   {
    { 0,0,1,1,1,0,0,0,0,0 },
    { 0,0,1,1,1,0,0,0,0,0 },
    { 0,0,0,1,1,1,1,1,1,0 },
    { 0,0,1,0,1,1,0,0,1,0 },
    { 1,1,1,0,1,1,0,1,1,1 },
    { 0,0,0,0,1,1,0,0,1,0 },
    { 0,0,0,1,1,1,1,0,0,0 },
    { 0,0,1,1,0,0,1,1,0,0 },
    { 0,0,0,1,1,1,1,0,0,0 },
    { 0,0,0,0,1,1,0,0,0,0 },
    { 0,0,0,0,1,0,1,0,0,0 },
    { 0,0,0,1,0,0,0,1,0,0 },
    };
    // code to toggle between both move left animations
    int x = rand() % 2;
    if (x == 0) {
        x = 1;
        lcd.drawSprite(_x,_y,12,10,(int *)run_left);
    }
    else if(x == 1) {
        x = 0;
        lcd.drawSprite(_x,_y,12,10,(int *)midrun_left);
    }
}


// ************************************************************************

void Enemy::move_right(N5110 &lcd) {

    const int run_right[12][10] =   {
    { 0,0,0,0,0,1,1,1,0,0 },
    { 0,0,0,0,0,1,1,1,0,0 },
    { 0,0,0,1,1,1,1,0,0,0 },
    { 0,0,1,1,1,1,1,0,1,0 },
    { 0,1,1,0,1,1,0,1,1,1 },
    { 0,0,0,0,1,1,0,0,1,0 },
    { 0,0,0,1,1,1,1,0,0,0 },
    { 0,0,1,1,0,0,1,1,0,0 },
    { 1,1,1,1,0,0,0,1,1,0 },
    { 0,0,0,0,0,0,1,1,0,0 },
    { 0,0,0,0,0,1,1,0,0,0 },
    { 0,0,0,0,1,1,0,0,0,0 },
    };
    const int midrun_right[12][10] =   {
    { 0,0,0,0,0,1,1,1,0,0 },
    { 0,0,0,0,0,1,1,1,0,0 },
    { 0,0,0,1,1,1,1,0,0,0 },
    { 0,0,1,1,1,1,1,0,1,0 },
    { 0,1,1,0,1,1,0,1,1,1 },
    { 0,0,0,0,1,1,0,0,1,0 },
    { 0,0,0,1,1,1,1,0,0,0 },
    { 0,0,1,1,0,0,1,1,0,0 },
    { 0,0,0,1,1,1,1,0,0,0 },
    { 0,0,0,0,1,1,0,0,0,0 },
    { 0,0,0,1,0,1,0,0,0,0 },
    { 0,0,1,0,0,0,1,0,0,0 },
    };
// code to toggle between both move right animations
    int x = rand() % 2;
    if (x == 0) {
        x = 1;
        lcd.drawSprite(_x,_y,12,10,(int *)run_right);
    }
    else if(x == 1) {
        x = 0;
        lcd.drawSprite(_x,_y,12,10,(int *)midrun_right);
    }
}



void Enemy::sword_right(N5110 &lcd) {
    const int swordsprite[12][10] =   {
    { 0,0,1,1,1,1,0,0,0,0 },
    { 1,0,1,1,1,1,0,0,0,0 },
    { 1,0,0,1,1,0,0,0,0,0 },
    { 1,1,0,1,1,0,1,0,0,0 },
    { 0,1,1,1,1,1,1,1,1,1 },
    { 0,0,0,1,1,0,1,0,0,0 },
    { 0,0,0,1,1,0,0,0,0,0 },
    { 0,0,0,1,1,0,0,0,0,0 },
    { 0,0,1,1,1,1,0,0,0,0 },
    { 0,1,1,0,0,1,1,0,0,0 },
    { 0,1,0,0,1,1,0,0,0,0 },
    { 1,1,0,0,1,0,0,0,0,0 },
    };
lcd.drawSprite(_x,_y,12,10,(int *)swordsprite);
}

// ************************************************************************


void Enemy::sword_left(N5110 &lcd) {
    const int swordsprite[12][10] =   {
    { 0,0,0,0,1,1,1,1,0,0 },
    { 0,0,0,0,1,1,1,1,0,1 },
    { 0,0,0,0,0,1,1,0,0,1 },
    { 0,0,0,1,0,1,1,0,1,1 },
    { 1,1,1,1,1,1,1,1,1,0 },
    { 0,0,0,1,0,1,1,0,0,0 },
    { 0,0,0,0,0,1,1,0,0,0 },
    { 0,0,0,0,0,1,1,0,0,0 },
    { 0,0,0,0,1,1,1,1,0,0 },
    { 0,0,0,1,1,0,0,1,1,0 },
    { 0,0,0,0,1,1,0,0,1,0 },
    { 0,0,0,0,0,1,0,0,1,1 },
    };
lcd.drawSprite(_x,_y,12,10,(int *)swordsprite);
}

// ************************************************************************


void Enemy::kick_right(N5110 &lcd) {
    const int kick[12][10] =   {
    { 0,1,1,0,0,0,0,0,0,0 },
    { 0,1,1,0,1,1,0,0,0,0 },
    { 0,0,0,1,1,1,1,0,0,1 },
    { 0,0,1,1,1,0,0,0,1,1 },
    { 0,1,1,1,1,1,1,1,0,0 },
    { 0,1,0,0,1,1,1,0,0,0 },
    { 1,1,1,0,1,1,0,0,0,0 },
    { 0,1,0,0,1,0,0,0,0,0 },
    { 0,1,0,1,1,0,0,0,0,0 },
    { 0,0,0,1,0,0,0,0,0,0 },
    { 0,0,1,1,0,0,0,0,0,0 },
    { 0,0,1,1,0,0,0,0,0,0 },
    };
lcd.drawSprite(_x,_y,12,10,(int *)kick);
}

// ************************************************************************


void Enemy::kick_left(N5110 &lcd) {
    const int kick[12][10] =   {
    { 0,0,0,0,0,0,0,1,1,0 },
    { 0,0,0,0,1,1,0,1,1,0 },
    { 1,0,0,1,1,1,1,0,0,0 },
    { 1,1,0,0,0,1,1,1,0,0 },
    { 0,0,1,1,1,1,1,1,1,0 },
    { 0,0,0,1,1,1,0,0,1,0 },
    { 0,0,0,0,1,1,0,1,1,1 },
    { 0,0,0,0,0,1,0,0,1,0 },
    { 0,0,0,0,1,1,0,0,1,0 },
    { 0,0,0,0,1,0,0,0,0,0 },
    { 0,0,0,0,1,1,0,0,0,0 },
    { 0,0,0,0,1,1,0,0,0,0 },
    };
lcd.drawSprite(_x,_y,12,10,(int *)kick);
}

// ************************************************************************

void Enemy::twoway_punch(N5110 &lcd){
    const int punchpunch[12][10] =   {
    { 0,0,0,0,0,0,0,0,0,0 },
    { 1,0,0,0,1,1,0,0,0,1 },
    { 0,1,0,0,1,1,0,1,1,0 },
    { 0,0,1,0,1,1,0,1,1,0 },
    { 0,0,0,1,1,1,1,0,0,0 },
    { 0,0,0,0,1,1,0,0,0,0 },
    { 0,0,0,0,1,1,0,0,0,0 },
    { 0,0,0,1,1,1,1,0,0,0 },
    { 0,0,1,1,0,0,1,1,0,0 },
    { 0,1,1,0,0,0,0,1,1,0 },
    { 0,1,0,0,0,0,0,0,1,0 },
    { 0,1,0,0,0,0,0,0,1,0 },
    };

lcd.drawSprite(_x,_y,12,10,(int *)punchpunch);
}

int Enemy::randomize_moves(N5110 &lcd, int input) {
    // return 1 to confirm collision
    int collision = 0;
    int move_number = rand()%12;
    draw(lcd, input);
    // enemy state: looking to the right (input is 1)
    if(input == 1) {
        if (move_number == 0) {
            kick_right(lcd);
            collision = 1;
        }
        else if (move_number == 1) {
            sword_right(lcd);
            collision = 1;
        }
        else if (move_number == 2){
            twoway_punch(lcd);
            collision = 1;
        }
        else{draw(lcd, input); // else have the enemy standing still but looking at fighter
            collision = 0;
        }
    }
    else if(input == 0) { // enemy state: looking to the left 
        if (move_number == 0) {
            kick_left(lcd);
            collision = 1;
        }
        else if (move_number == 1) {
            sword_left(lcd);
            collision = 1;
        }
        else if (move_number == 2){
            twoway_punch(lcd);
            collision = 1;
        }
        else{draw(lcd, input);
            collision = 0;
        }
    }
    return collision;
}




