
#include "mbed.h"
#include "math.h"
#include "DHT.h"
#include <string>

Serial FRDM_UART_Debug(USBTX,USBRX);


DHT sensor(PTC10,22); //DHT Sensor


float Temp_Out = 0;
float Hum_Out = 0;


int main() 
{
    int SPI_High_byte = 0;
    int SPI_Low_byte = 0; 
    float Temp_f_1 = 0.00;
    float Temp_f_2 = 0.00;
    int Temp_i_1 = 0;
    int Temp_i_2 = 0;
    int Temp_i_3 = 0;
    int Temp_i_4 = 0;
    char I2C_Cmd[3];
    int loop_count = 0;
  
    
    FRDM_UART_Debug.baud(115200);           // Baud rate used for communicating with Tera-term on PC
    
    
    FRDM_UART_Debug.printf("Start sampling data\r\n");  // Starting point
    
    while (1) 
    {
       
        int error = 0;
    float h = 0.0f, c = 0.0f, f = 0.0f, k = 0.0f, dp = 0.0f, dpf = 0.0f;

    
        wait(2.0f);
        error = sensor.readData();
        FRDM_UART_Debug.printf("Error: %d\n", error);
        if (0 == error) {
            c   = sensor.ReadTemperature(CELCIUS);
            f   = sensor.ReadTemperature(FARENHEIT);
            k   = sensor.ReadTemperature(KELVIN);
            h   = sensor.ReadHumidity();
            dp  = sensor.CalcdewPoint(c, h);
            dpf = sensor.CalcdewPointFast(c, h);
            FRDM_UART_Debug.printf("Temperature in Celcius is %4.2f \n\r", c);
            FRDM_UART_Debug.printf("Humidity is %4.2f\n\r", h);
             } 
       else {
            FRDM_UART_Debug.printf("Error: %d\n", error);
        }
    
        

        
    }
} 