#include "mbed.h"
#include "MGC3130.h"

DigitalOut myled(LED1);
 
Serial pc(SERIAL_TX, SERIAL_RX);
 
    /** 
    * IS2 is available for address selection and enables the user to connect up to two MGC3X30 devices on the same bus without address conflict.
    * The MGC3X30 I2C addresses are 0x42 and 0x43. They are given as device addresses without the R/W bit.
    * In addition, MGC3X30 requires a dedicated transfer status line (TS), which features a
    * data transfer status function. The TS is used by both I2C Master and Slave to control
    * the data flow. I2C SCL, I2C SDA and TS lines require an open-drain connection on
    * MGC3X30 and the connected host controller. To function properly, I2C SCL and I2C
    * SDA need to be pulled up to VCC with 1.8 kΩ resistors and the TS line needs to be
    * pulled up to VCC with a 10 kΩ resistor.
    *
    * @param sda I2C sda signal
    * @param scl I2C scl signal
    * @param EI0 transfer status line
    * @param IS2 High->true, Low->false
    *
    */
     
MGC3130 gestic(I2C_SDA, I2C_SCL, PB_1, false ); 

SensorData *data;

 
int main()
{
 
    pc.printf("Hello World !\r\n");
 
    while (1) {
        data = gestic.readSensorData();
        if (data == NULL){
            pc.printf("Data not avail\r\n");
            }
            else{
                if (NULL != data->getxyzPosition())
                    pc.printf("Got position data \r\n");
                }
 
        // Display result
        myled = !myled;
        wait(1.0);
    }
 
}
 
