#include "mbed.h"
#include "USBHostKeyboard.h"
#include "SDFileSystem.h"
DigitalOut led(LED1);
SDFileSystem sd(p5, p6, p7, p8, "sd");

int i=0;    //カウント用の変数を初期化
Timer keytime;



void onKey(uint8_t key) {
    
    keytime.stop();
    
    printf("Key: 0x%x : %c\r\n", key, key);
    printf("The time taken was %f seconds\n", keytime.read());
    keytime.reset();

    ++i;
    FILE *fp;
    fp = fopen("/sd/keylog/keylog.csv", "a");
    fprintf(fp, "Keydata[%d], :,0x%x,:,%c\r\n", i, key, key);//iは押した順番,keyは押したキーのキーコード,keyは押したキーの文字
    fclose(fp); 

}

void keyboard_task(void const *) {
    
    USBHostKeyboard keyboard;
    
    while(1) {
        // try to connect a USB keyboard
        while(!keyboard.connect())
            Thread::wait(500);
    
        // when connected, attach handler called on keyboard event
        keyboard.attach(onKey);
        
        // wait until the keyboard is disconnected
        while(keyboard.connected())
            Thread::wait(500);
    }
}

int main() {
    mkdir("/sd/keylog", 0777);
    FILE *fp;
    fp = fopen("/sd/keylog/keylog.csv","w");
    keytime.start();
    fclose(fp);
    
    Thread keyboardTask(keyboard_task, NULL, osPriorityNormal, 256 * 4);
    while(1) {
        led=!led;
        Thread::wait(500);
    }
}
