#ifndef SERIALPROMPT_H
#define SERIALPROMPT_H
#include "EngineDriver.h"
#include "VoltageGetter.h"
#include "mbed.h"
const char* prompt = "$>";
const char* help = "h - help  d - drive driving unit\n\r v - get input voltage s - get collision sensor distance \n\r";
const char* drivingMode = "Going to driving mode.\n\r Available commands: e - exit from driving mode \n\r";
const char* voltage = "Actual voltage: %g \n\r";
bool isDriving = false;
AnalogIn voltagePin(A0);
extern int inState[4];
extern void applyStates();
extern const char* distMsg;
extern float actualDistance;
void displayPrompt(Serial* pcConnection)
{
    pcConnection->printf(prompt);
}
void displayMessage(const char* msg, Serial* pcConnection)
{
    pcConnection->printf(msg);
    displayPrompt(pcConnection);
}
void displayMessage(const char* msg, Serial* pcConnection, float number)
{
     pcConnection->printf(msg, number);
    displayPrompt(pcConnection);
}
///
/// 0 - not known command
/// 2 - drive the driving unit
int getMenuInput(Serial* pcConnection)
{
    if(pcConnection->readable())
    {
        char msg = pcConnection->getc();
        if(msg == 'h')
        {
            displayMessage(help, pcConnection);
        }else if(msg == 'd')
        {
            displayMessage(drivingMode, pcConnection);
            isDriving = true;      
            return 2;
        }else if(msg == 'v')
        {
            displayMessage(voltage, pcConnection, getVoltage(&voltagePin));
            return 3;
        }else if(msg == 's')
        {
            displayMessage(distMsg, pcConnection, actualDistance);
            return 4;
        }
    }
    return 0;
}

#endif // SERIALPROMPT_H