#ifndef DRIVER_H
#define DRIVER_H
#include "mbed.h"
#include "SerialPrompt.h"
DigitalOut en1(D2);
DigitalOut en2(D4);
DigitalOut in1(D3);
DigitalOut in2(D5);
DigitalOut in3(D6);
DigitalOut in4(D7);
DigitalIn enableAllButton(USER_BUTTON);
int inState[4] = {0,0,0,0};
bool canDrive = true;
int buttonClicks = 0;
void applyStates()
{
        in1 = inState[0];
        in2 = inState[1];
        in3 = inState[2];
        in4 = inState[3];
}
void resetEngines()
{
    for(int i = 0; i < 4; ++i)
    {
        inState[i] = 0;
    }
    applyStates();
}
void forward()
{
    resetEngines();
    inState[0] = 0;
    inState[1] = 1;
    inState[2] = 0;
    inState[3] = 1;
    applyStates();
}
void testEngines()
{
    int i = 0;
    while(i < 4)
    {
        if(i % 2 == 0)
        {
            inState[i] = 1;
        }
        i++;
    }
    applyStates();
    wait(5);
    resetEngines();
    int j = 0;
    while(j < 4)
    {
        if(j % 2 != 0)
        {
            inState[j] = 1;
        }
        j++;
    }
    applyStates();
    wait(5);
    resetEngines();
}
void checkEnableButtonState()
{
    if(enableAllButton == 0)
    {
        buttonClicks++;
        while(enableAllButton == 0);
        return;
    }
     if(buttonClicks == 1)
        {
            canDrive = false;
            resetEngines();
            return;
        }else if(buttonClicks == 2)
        {
            canDrive = true;
            applyStates();
            return;
        }else
        {
            buttonClicks = 0;
            return;
        }

}
void enableAll()
{
    en1 = 1;
    en2 = 1;
}
void enableOne(int which)
{
    if(which == 0)
    {
        en1 = 1;
    }else if(which == 1)
    {
        en2 = 1;
    }
}
void disableAll()
{
    en1 = 0;
    en2 = 0;
}
void disableOne(int which)
{
    if(which == 0)
    {
        en1 = 0;
    }else if(which == 1)
    {
        en2 = 0;
    } 
}
#endif //DRIVER_H