#include "mbed.h"
#include "TS_DISCO_F429ZI.h"
#include "LCD_DISCO_F429ZI.h"
#include "stlogo.h"

#define TOUCH_STRING_IDX 0
#define COORD_STRING_IDX 2

LCD_DISCO_F429ZI lcd;
TS_DISCO_F429ZI ts;
int main()
{
    TS_StateTypeDef TS_State;
    uint32_t x, y;
    uint8_t text[30];
    uint8_t status;
    uint8_t idx;
    bool cleared = false;

    BSP_LCD_SetFont(&Font20);
  
    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"DEMO", CENTER_MODE);
    wait(1);
  
    status = ts.Init(lcd.GetXSize(), lcd.GetYSize());
  
    if (status != TS_OK)
    {
      lcd.Clear(LCD_COLOR_RED);
      lcd.SetBackColor(LCD_COLOR_RED);
      lcd.SetTextColor(LCD_COLOR_WHITE);
      lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN", CENTER_MODE);
      lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"INIT FAIL", CENTER_MODE);
    }
    else
    {
      lcd.Clear(LCD_COLOR_GREEN);
      lcd.SetBackColor(LCD_COLOR_GREEN);
      lcd.SetTextColor(LCD_COLOR_WHITE);
      lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN", CENTER_MODE);
      lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"INIT OK", CENTER_MODE);
    }
    
    wait(1);
    lcd.Clear(LCD_COLOR_BLUE);
    lcd.SetBackColor(LCD_COLOR_BLUE);
    lcd.SetTextColor(LCD_COLOR_WHITE);

    while(1) {
        lcd.DrawBitmap(x,  y, (uint8_t *)stlogo);
        ts.GetState(&TS_State);
        if (TS_State.TouchDetected) {
            cleared = 0;
            
            lcd.ClearStringLine(TOUCH_STRING_IDX);
            lcd.DisplayStringAt(0, LINE(TOUCH_STRING_IDX), (uint8_t *)"TOUCH", LEFT_MODE);

            lcd.SetTextColor(LCD_COLOR_BLUE);
            lcd.FillRect(x,y,80,60);
            lcd.SetTextColor(LCD_COLOR_WHITE);
            
            x = TS_State.X;
            y = lcd.GetYSize() - TS_State.Y;
            
            lcd.DisplayStringAt(0, LINE(1), (uint8_t *)"COORDS:", LEFT_MODE);
            lcd.ClearStringLine(COORD_STRING_IDX);
            sprintf((char*)text, "x=%d y=%d", x, y);
            lcd.DisplayStringAt(0, LINE(COORD_STRING_IDX), (uint8_t *)&text, LEFT_MODE);
            lcd.DrawBitmap(x, y, (uint8_t *)stlogo);
            
        } else {
            if (!cleared) {
                lcd.DisplayStringAt(0, LINE(0), (uint8_t *)"NO TOUCH", LEFT_MODE);
                cleared = 1;
            }
        }
        wait_ms(50); // debounce for loading frame
    }
}

