#include "mbed.h"
#include "GYRO_DISCO_F429ZI.h"
#include "LCD_DISCO_F429ZI.h"
#include "stm32f429i_discovery_lcd.h"
 
GYRO_DISCO_F429ZI gyro;
LCD_DISCO_F429ZI lcd;
 
DigitalOut led1(LED1);

bool isInMotion = false;
 
int main()
{
    float GyroBuffer[3];
    float zero_level[3] = {0, 0, 0};
    uint8_t buffer[100];
    lcd.Init();
    lcd.DisplayStringAt(0, LINE(1), (uint8_t*)"Started", CENTER_MODE);
    uint8_t tmpreg = 0;
    GYRO_IO_Read(&tmpreg,I3G4250D_CTRL_REG4_ADDR,1);
    switch(tmpreg & I3G4250D_FULLSCALE_SELECTION)
    {
        case I3G4250D_FULLSCALE_245:
            lcd.DisplayStringAt(0, LINE(2), (uint8_t*)"245", CENTER_MODE);
        break;
    
        case I3G4250D_FULLSCALE_500:
            lcd.DisplayStringAt(0, LINE(2), (uint8_t*)"500", CENTER_MODE);
        break;
    
        case I3G4250D_FULLSCALE_2000:
            lcd.DisplayStringAt(0, LINE(2), (uint8_t*)"2000", CENTER_MODE);
        break;
  }
    GYRO_IO_Read(&tmpreg, I3G4250D_CTRL_REG1_ADDR, 1);
    switch(tmpreg >> 6) {
        case 0:
            lcd.DisplayStringAt(0, LINE(3), (uint8_t*)"95", CENTER_MODE);
            break;
        case 1:
            lcd.DisplayStringAt(0, LINE(3), (uint8_t*)"190", CENTER_MODE);
            break;
        case 2:
            lcd.DisplayStringAt(0, LINE(3), (uint8_t*)"380", CENTER_MODE);
            break;
        case 3:
            lcd.DisplayStringAt(0, LINE(3), (uint8_t*)"760", CENTER_MODE);
            break;
    }
 
    for (int i = 0; i < 50; i++) {
        gyro.GetXYZ(GyroBuffer);
        zero_level[0] += GyroBuffer[0] / 17.5f;
        zero_level[1] += GyroBuffer[1] / 17.5f;
        zero_level[2] += GyroBuffer[2] / 17.5f;
 
        wait_ms(10);
    }
    for (int i = 0; i < 3; i++)
        zero_level[i] /= 50;
    
    float noise_level = 0.0f;
    for (int i = 0; i < 50; i++) {
        gyro.GetXYZ(GyroBuffer);
        if ((GyroBuffer[0] / 17.5f - zero_level[0]) > noise_level) {
            noise_level = (GyroBuffer[1] / 17.5f - zero_level[0]);
        } 
        else if ((GyroBuffer[0] / 17.5f - zero_level[0]) < -noise_level) {
            noise_level = -(GyroBuffer[1] / 17.5f - zero_level[0]);
        }
        wait_ms(10);
    }
    sprintf((char*)buffer, "Noise %.2f", noise_level);
    lcd.DisplayStringAt(0, LINE(4), buffer, CENTER_MODE);
    float angle = 0.0f, prev_value = 0.0f;
    float saved_angle = 0.0f;
    while(1) {
        // Read Gyroscope values
        wait(0.02);
        
        gyro.GetXYZ(GyroBuffer);
        float value = GyroBuffer[0] / 17.5f - zero_level[0];
        if (value >= noise_level || value <= -noise_level) {
            if(value >= 0.1f) {
                if(!isInMotion){
                    saved_angle = angle;
                }
                isInMotion = true;
            }
            angle += (value + prev_value) / 2 * 0.0175f * 0.02f / 0.825f;
        } else {
            isInMotion = false;
            if(fabs(saved_angle - angle) >= 45.0f){
                lcd.ClearStringLine(7);
                lcd.ClearStringLine(8);
                lcd.DisplayStringAt(0, LINE(7), (uint8_t*)"Gesture", CENTER_MODE);
                sprintf((char*)buffer, "Angle %.3f", angle - saved_angle);
                lcd.DisplayStringAt(0, LINE(8), buffer, CENTER_MODE);
            }
            saved_angle = angle;
        }
        prev_value = value;
        sprintf((char*)buffer, "Angle %.3f", angle);
        lcd.ClearStringLine(6);
        lcd.DisplayStringAt(0, LINE(6), buffer, CENTER_MODE);
        
    }
}