#include "mbed.h"
#include "LCD_DISCO_F429ZI.h"
#include "stlogo.h"

/**
  * @brief  Creates uint32_t ARGB color variable from separate uint8_t values
  * @param  a: Alpha channel
  * @param  r: Red color value
  * @param  g: Green color value
  * @param  b: Blue color value
  * @retval Color value bytes combined in uint32_t
*/
uint32_t colorFromSeparateValues(uint8_t a,uint8_t r,uint8_t g, uint8_t b);

LCD_DISCO_F429ZI lcd;

int main(){
    uint32_t xSize = lcd.GetXSize();
    uint32_t ySize = lcd.GetYSize();
    
    lcd.Clear(LCD_COLOR_BLACK);
    lcd.SelectLayer(0);
    lcd.DrawBitmap(xSize/2 - 30,ySize/2 - 20,stlogo);
    lcd.SelectLayer(1);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.FillRect(0,0,xSize, ySize);
    lcd.SelectLayer(0);
    
    uint8_t procIdentifier = 0;
    uint8_t frontLayerTransparency = 0x00;
    
    while(1){
        if(procIdentifier % 2) {
            --frontLayerTransparency;
        }
        else {
            ++frontLayerTransparency;
        }
        lcd.SetTransparency(1, frontLayerTransparency);
        
        if(frontLayerTransparency == 0x00 || frontLayerTransparency == 0xff){
            ++procIdentifier;
            procIdentifier = procIdentifier % 4;
            
            if(procIdentifier == 0){
                lcd.Clear(LCD_COLOR_BLACK);
                lcd.DrawBitmap(xSize/2 - 30,ySize/2 - 20,stlogo);
            } else if(procIdentifier == 2){
                lcd.SetTextColor(LCD_COLOR_GREEN);
                lcd.FillRect(0,0,xSize, ySize);
            }
        }
        wait_ms(5);
    }
}

uint32_t colorFromSeparateValues(uint8_t a,uint8_t r,uint8_t g, uint8_t b) {
    uint32_t res = a;
    res = (res >> 8) + r;
    res = (res >> 8) + g;
    res = (res >> 8) + b;
    return res;
}
