#ifndef PARALLAX_X_BAND_H
#define PARALLAX_X_BAND_H
#include "mbed.h"

/**
 * Wrapper for the Parallax X-Band Motion Detector
 */
class xband
{
public:

    /** 
    * Initialize the xband motion detector and setup interrupts on specified pins.
    * Default is to be disabled.
    *
    * @param pin_enable Enable pin. Connected to EN on xband.
    * @param pin_input Data pin. Connected to OUT on xband.
    */ 
    xband(PinName pin_enable, PinName pin_input);
    
    /**
    * Destructor
    */
    ~xband();
    
    /** 
    * Subroutine to enable and disable the detector.
    *
    * @param enable True to enable, False to disable.
    */ 
    void enable(bool enable);

    /** 
    * Get count value and return it as an integer.
    *
    * @return Integer value of current count.
    */ 
    int read_count();
    
    /** 
    * Resets the count variable to 0.
    */ 
    void reset_count();
    
    /** 
    * Checks if a new velocity value has been calculated.
    *
    * @return True if a new velocity value is avaliable. False if the value has
    * already been read.
    */ 
    bool velocityack();
    
    /** 
    * Get current velocity reading in ticks/sec. Sets a flag to false to indicate a stale value after reading.
    *
    * @return Float value of currently measured velocity.
    */ 
    float read_velocity();
    
    /** 
    * Default overload to read velocity.
    *
    * @return Float value of currently measured velocity.
    */ 
    operator float();
    
private:    
    /** 
    * Interrupt service routine to collect data on the input pin.
    */ 
    void xband_RiseISR();
    
    /** 
    * Interrupt service routine to calculate the velocity of the moving object.
    */ 
    void xband_velocityISR();

    // Setup pin input types.
    DigitalOut _pin_enable;
    InterruptIn _pin_input;

    // Stores count value.
    volatile int _count;
    // Old count value.
    volatile int _lastcount;
    // Store calculated velocity.
    float _velocity;
    // Velocity read status flag.
    bool _velocityflag;

    // Timer for differentiation
    Timer _sampletime;
    
    // Interrupt to calculate velocity.
    Ticker _samplevelocity;
};

#endif