#include "mbed.h"
#include "BMP085.h"
#include "uLCD_4DGL.h"
#include "statistics.h"
#include "spikes.h"

#define SHORT_SAMPLE 5
#define LONG_SAMPLE 20

BMP085 barometer(p9, p10);
uLCD_4DGL uLCD(p28, p27, p29);
AnalogIn ain(p17);
Ticker ticker;
//SpikeFinder s = SpikeFinder(30, 6, 4.0);
// For wind sensor:
//SpikeFinder s = SpikeFinder(40, 10, 7.0);
// For pressure sensor:
SpikeFinder s = SpikeFinder(4, 4, 3.0); 

void tick() {
    __disable_irq();
    barometer.update();
    s.addSample(barometer.get_pressure());
    __enable_irq();
}

int main() { 
    while(1) {
        //ticker.attach(&tick, 0.04);
        ticker.attach(&tick, .1);
        wait(1);
        float f = ain;
        uLCD.printf("Low: %s, High : %s\n", s.lowSpikeFound() ? "true":"false", s.highSpikeFound() ? "true":"false");
        wait(1);
        uLCD.printf("Low: %s, High : %s\n", s.lowSpikeFound() ? "true":"false", s.highSpikeFound() ? "true":"false");
        wait(1);
        ticker.detach();
        s.reset();
        wait(1);
        uLCD.cls();
    } 
    return 0;
}

