 /* Copyright (c) 2015 NXP Semiconductors. MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "MPL3115.h"
#include "mbed.h"
#define REG_PRESSURE_MSB    0x01

MPL3115::MPL3115(PinName sda, PinName scl, int addr) : MPL3115_i2c(sda,scl), m_addr(addr)
 {
       
 }
    
 void MPL3115::config(void)
 {
   char d[2]; 
   d[0] = MPL3115_CTRL_REG1;                     //Puts device in Standby mode
   d[1] = 0x00; 
   MPL3115_i2c.write(MPL3115_I2C_ADDRESS, d,2);   
          
   
   d[0] = MPL3115_CTRL_REG1;                     //Puts device in Active mode and in altimeter mode
   d[1] = 0x81;
   MPL3115_i2c.write(MPL3115_I2C_ADDRESS, d, 2);   
      
 }
 

 float MPL3115::getPressure(void)
{
    float a;
    
    a = getPressure(REG_PRESSURE_MSB);
    return a;
}
 
 float MPL3115::getPressure(unsigned char reg)
{
    unsigned char dt[3];
    unsigned int prs;
    int tmp;
    float fprs;
    
    /*
    * dt[0] = Bits 12-19 of 20-bit real-time Pressure sample. (b7-b0)
    * dt[1] = Bits 4-11 of 20-bit real-time Pressure sample. (b7-b0)
    * dt[2] = Bits 0-3 of 20-bit real-time Pressure sample (b7-b4)
    */
    readRegs( reg, &dt[0], 3);
    prs = ((dt[0]<<10) | (dt[1]<<2) | (dt[2]>>6));
    //
    if ( dt[0] > 0x7f) {
        // negative number
        if ( dt[0] & 0x80)
            prs |= 0xFFFC0000;      
        else
            prs |= 0xFFFE0000;
        tmp = ~prs + 1;             // make the complemets. At this point all the bits are inverted.
        fprs = (float)tmp * -1.0f;  
    } else {
        fprs = (float)prs * 1.0f;
    }
 
    if ( dt[2] & 0x10)              
        fprs += 0.25f;             
    if ( dt[2] & 0x20)
        fprs += 0.5f;
        
    return fprs;
}
 void MPL3115::readRegs(int addr, uint8_t * data, int len) {
    char t[1] = {addr};
    MPL3115_i2c.write(m_addr, t, 1, true);
    MPL3115_i2c.read(m_addr, (char *)data, len);
}
 