#include "statistics.h"

RunningStatistics :: RunningStatistics(int numSamples) {
    sum = 0;
    sumSquares = 0;
    average = 0;
    count = 0;
    samples = new double [numSamples];
    currentNdx = 0;
    sampleSize = numSamples;
}


double RunningStatistics :: addSample(double newSample) {
    double temp;

    if (count == sampleSize) {
        temp = samples[(currentNdx) % sampleSize];
        sum -= temp;
        sumSquares -= (temp * temp);
    }
    sum += newSample;
    sumSquares += (newSample * newSample);
    samples[currentNdx % sampleSize] = newSample;
    
    
    if (count < sampleSize) {
        ++count;
    }
    average = (sum / count);
    
    ++currentNdx;
    if (currentNdx >= sampleSize) {
        currentNdx = currentNdx % sampleSize;
    }
    return temp;
}

double RunningStatistics :: getAverage() {
    return average;
}

double RunningStatistics :: getStandardDeviation() {
    return sqrt((sumSquares - (count * average * average)) / (count - 1));
}

int RunningStatistics :: getCount() {
    return count;
}
 
double RunningStatistics :: getSum() {
    return sum;
}

void RunningStatistics :: reset() {
    delete [] samples;
    sum = 0;
    sumSquares = 0;
    average = 0;
    count = 0;
    samples = new double[sampleSize];
    currentNdx = 0;
}