#include "mbed.h"
#include "SDFileSystem.h"
#include "wave_player.h"
//#include "uLCD_4DGL.h"
#include "PinDetect.h"
#include "Heart.h"
#include "statistics.h"
#include "spikes.h"
#include "BMP085.h"
#include <string>
#include <sstream>

using namespace std;

#define SHORT_SAMPLE 5
#define LONG_SAMPLE 20

#define BEGIN_COMPRESSIONS "begin30ChestCompressions"
#define BREATH_TONE "breathTone"
#define CLIP_SENSOR "clipPulseSensorToEar"
#define CONTINUE_COMPRESSIONS "continueChestCompressions"
#define PLACE_MASK "placeMaskOverVictimsMouthWithTheSharpestCornerOverTheNose"
#define PREPARE_BREATH "prepareToBreatheIntoMask"
#define ROLL_VICTIM "rollVictimOntoSide"
#define START_BREATHING "startBreathing"
#define STOP_COMPRESSIONS "stopChestCompressions"
#define TILT_HEAD "tiltHeadBackFor10Seconds"
#define MONITOR_CONDITION "monitorVictimConditionAndReturnMaskToFaceIfBreathingStops"
#define RETILT_HEAD "retiltHeadByPushingChinAwayFromChest"
#define NEXT_KEY "pressNextKeyWhenReady"
#define NEXT_REMINDER "pleasePressNextKeyToContinueOrPressRepeatToHearTheLastCommand"
#define CHEST_COMPRESSIONS "prepareForChestCompressions"
#define REMOVE_MASK "removeTheMaskAndCheckTheAirway"
#define REMOVE_OBJECT "removeObject"
#define REPLACE_MASK "replaceMaskOnVictimsFace"
#define COUNT "count"
string lastMessage;

SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
AnalogOut DACout(p18);
wave_player waver(&DACout);
AnalogIn windSensor(p17);
PinDetect repeatButton(p14);
PinDetect nextButton(p13);
Timer timer;
Heart heart = Heart();
BMP085 barometer(p9, p10);
Ticker ticker;
SpikeFinder s = SpikeFinder(4, 4, 4.0);
DigitalOut GLED1(p26);
DigitalOut GLED2(p25);
DigitalOut GLED3(p24);
DigitalOut RLED1(p23);
DigitalOut RLED2(p22);
DigitalOut RLED3(p21);
DigitalOut testLED(LED1);
float windSensorVoltage;
bool breathing; 
bool pulse;
bool breath_success = true; 
ostringstream stream;
Timer breathTimer;
bool next = false;
bool adult = true;
int cycleCount = 0;
Ticker LEDTicker;

void playMessage(string messageName);
void getBreathing();
void getPulse();
void getVitals();
bool checkBreath();
void promptBreaths(int amt,bool check);
void chestCompressions();
void CPR();
void rescueBreathing();
void auditVitals();
void unconsciousChocking();
void repeat_callback_function (void);
void next_callback_function (void);
void waitForNext();
void tick();
void welcomeLED();
void cycleLEDs();

int main(){
    repeatButton.mode(PullUp);
    nextButton.mode(PullUp);
    wait(1);
    repeatButton.attach_deasserted(&repeat_callback_function);
    nextButton.attach_deasserted(&next_callback_function);
    repeatButton.setSampleFrequency();
    nextButton.setSampleFrequency();
    wait(1);
    
    /*while(1){
        printf("HERE");
        waitForNext();
        checkBreath();
        wait(0.5);
    }*/
    
    welcomeLED();
    testLED = 1;
    wait(3);
    playMessage(PLACE_MASK);
    testLED = 0;
    wait(3);
    waitForNext();
    playMessage(CLIP_SENSOR); 
    waitForNext();
    playMessage(TILT_HEAD);
    waitForNext();
    getVitals();
    
    if(pulse){
        playMessage(ROLL_VICTIM);
        while(1){
            playMessage(MONITOR_CONDITION);
            wait(5);
        }
    }
    
    promptBreaths(2,true);
    if(breath_success){
        auditVitals();
    }else{
        playMessage(RETILT_HEAD);
        waitForNext();
        promptBreaths(1,true);
        if(breath_success){
            auditVitals();
        }else{
            unconsciousChocking();
        }
    }
}

void repeat_callback_function (void){
    playMessage(lastMessage);
}

void next_callback_function (void){
    next = true;
}

void tick() {
    __disable_irq();
    barometer.update();
    s.addSample(barometer.get_pressure());
    __enable_irq();
}

void waitForNext(){
    playMessage(NEXT_KEY);
    timer.start();
    while(!next){
        if(timer.read()>3){
            playMessage(NEXT_REMINDER);
            timer.reset();
        }
    }
    timer.stop();
    timer.reset();
    next = false;
}

void playMessage(string messageName){
    string pathName = "/sd/" + messageName + ".wav";
    char * cstrName = new char[pathName.length() + 1];
    cstrName[pathName.length()]=0;
    memcpy(cstrName,pathName.c_str(),pathName.size());
    FILE *wave_file;
    wave_file=fopen(cstrName,"r");
    waver.play(wave_file);
    fclose(wave_file);
    wait(1);
    if(messageName.compare(NEXT_REMINDER) != 0
            && messageName.compare(NEXT_KEY) != 0){
        lastMessage = messageName;
    }
}

void getBreathing(){
    //SENSOR DATA
    breathing = false;
}

void getPulse(){
    pulse = heart.beatDetected(); 
}

void getVitals(){
    timer.start();
    heart.startReading();
    while(timer.read()<10){}
    heart.stopReading();
    
    getBreathing();
    getPulse();
    
    timer.stop();
    timer.reset();
    heart.reset();
}

bool checkBreath(){
    windSensorVoltage = 0;
    ticker.attach(&tick, .1);
    while(windSensorVoltage<6.15){
        while(windSensorVoltage<6.15){
            wait(0.1);
            windSensorVoltage = windSensor*10;
            printf("%f",windSensorVoltage);
            //THINK OF ANOTHER WAY THAT DOESN'T INVOLVE A SECOND WHILE LOOP
        }
        windSensorVoltage = windSensor*10;
        wait(0.5);
    }
    //uLCD.printf("BREATH DETECTED");
    cycleLEDs();
    LEDTicker.attach(&cycleLEDs,0.116);
    cycleLEDs();
    playMessage(BREATH_TONE);
    LEDTicker.detach();
    ticker.detach();
    while(windSensorVoltage>6.15){
        windSensorVoltage = windSensor*10;
    }
    if(s.highSpikeFound()){
        s.reset();
        return false;
    }else{
        s.reset();
        return true;
    }   
}

void promptBreaths(int amt,bool check){
    bool local_check;;
    for(int i = 0;i<amt;i++){
        playMessage(PREPARE_BREATH);
        if(check){
            waitForNext();
        }
        playMessage(START_BREATHING);
        local_check = checkBreath();
        breath_success = breath_success & local_check;
    }
}

void chestCompressions(){
    playMessage(CHEST_COMPRESSIONS);
    waitForNext();
    playMessage(BEGIN_COMPRESSIONS);
    wait(1);
    playMessage(COUNT);
    playMessage(STOP_COMPRESSIONS); 
}

void CPR(){
    while(1){
        promptBreaths(2,true);
        chestCompressions();
    }
}

void rescueBreathing(){
    while(pulse){
        timer.start();
        while(timer.read()<120){
            promptBreaths(1,false);
            if(adult){
                wait(3); //Need 5s total loop time if adult
            }else{
                wait(1); //Need 3s total loop time if child
            }
        }
        timer.stop();
        timer.reset();
        playMessage(TILT_HEAD);
        waitForNext();
        getVitals();
    }
    CPR();
}

void auditVitals(){
    if(pulse && !breathing){
        rescueBreathing();
    }else if(!pulse && !breathing){
        CPR();
    }else{//ERROR}
    }
}

void unconsciousChocking(){
    bool stillChocking = true;
    while(stillChocking){
        chestCompressions(); 
        playMessage(REMOVE_MASK);
        playMessage(REMOVE_OBJECT);
        waitForNext();
        playMessage(REPLACE_MASK);
        promptBreaths(2,true);
        if(breath_success){
            stillChocking = false;
        }  
    }
    playMessage(TILT_HEAD);
    waitForNext();
    getVitals();
    auditVitals();
}

void cycleLEDs(){
    cycleCount++;
    if(cycleCount==1){
        RLED1 = 1;
    }
    if(cycleCount==2){
        RLED2 = 1;
    }
    if(cycleCount==3){
        RLED3 = 1;
    }
    if(cycleCount==4){
        GLED1 = 1;
    }
    if(cycleCount==5){
        GLED2 = 1;
    }
    if(cycleCount==6){
        GLED3 = 1;
    }
    if(cycleCount==7){
        GLED1 = 0;
        GLED2 = 0;
        GLED3 = 0;
        RLED1 = 0;
        RLED2 = 0;
        RLED3 = 0;
        cycleCount = 0;
    }
}

void welcomeLED(){
    for(int i =0;i<5;i++){
        GLED1 = 1;
        GLED2 = 1;
        GLED3 = 1;
        RLED1 = 1;
        RLED2 = 1; 
        RLED3 = 1;
        wait (0.5);
        GLED1 = 0;
        GLED2 = 0;
        GLED3 = 0;
        RLED1 = 0;
        RLED2 = 0;
        RLED3 = 0; 
    }
    RLED1 = 1;
    wait(0.1);
    RLED1 = 0;
    RLED2 = 1;
    wait(0.1);
    RLED2 = 0;
    RLED3 = 1;
    wait(0.1);
    RLED3 = 0;
    GLED1 = 1;
    wait(0.1);
    GLED1 = 0;
    GLED2 = 1;
    wait(0.1);
    GLED2 = 0;
    GLED3 = 1;
    wait(0.2);
    GLED3 = 0;
    GLED2 = 1;
    wait(0.1);
    GLED2 = 0;
    GLED1 = 1;
    wait(0.1);
    GLED1 = 0;
    RLED3 = 1;
    wait(0.1);
    RLED3 = 0;
    RLED2 = 1;
    wait(0.1);
    RLED2 = 0;
    RLED1 = 1;
    wait(0.1);
    RLED1 = 0;
}