#include "spikes.h"
#include "statistics.h"
#include "mbed.h"
#include "math.h"
volatile bool lowSpike;
volatile bool highSpike;

RunningStatistics *oldValues;
RunningStatistics *newValues;

int numOld, numNew, stdDevs, capacity;
volatile int count = 0;

SpikeFinder :: SpikeFinder(int numOld, int numNew, float stdDevs) {
    oldValues = new RunningStatistics(numOld);
    newValues = new RunningStatistics(numNew);
    this->numOld = numOld;
    this->numNew = numNew;
    this->stdDevs = stdDevs;
    capacity = numNew + numOld;
}

bool SpikeFinder :: lowSpikeFound() {
    return lowSpike;
}
    
bool SpikeFinder :: highSpikeFound() {
    return highSpike;
}
    
void SpikeFinder :: addSample(double newSample) {
    oldValues->addSample(newValues->addSample(newSample));
    if(count < capacity) {
        count++;
    } else {
        double oldAvg = oldValues->getAverage();
        double newAvg = newValues->getAverage();
        double newStdDev = newValues->getStandardDeviation();
        double dist = newStdDev * stdDevs;
        if (newAvg >= (oldAvg + dist)) {
            highSpike = true;
        }
        else if (newAvg <= (oldAvg - dist)) {
            lowSpike = true;
        }
    }
}

void SpikeFinder :: reset() {
    count = 0;
    highSpike = false;
    lowSpike = false;
}