#include "mbed.h"
#include "NeoStrip.h"
#include "MPL3115.h"
#include <vector>

class windSensor {
public:
    windSensor(PinName p, NeoStrip *_strip, PinName p2, PinName p3);
    /* Start victim breath */
    void sample();
    void startReading();
    void stopReading();
    void reset();
    bool breathDetected();
    /* End vicim breath */
    
    /* start give breath */
    float give_breath(void);
    bool pressureSpikeDetected();
    /* end give breath */
    
private:
    /* start vicim breath */
    AnalogIn sensor;
    Ticker breathReader;

    volatile float thresh;
    //volatile bool Breath = false;     // set on each visit to interrupt routine
    volatile bool isBreathing;
    volatile int breathCount; //increment if breath is above thresh on each visit to interrupt routine
    /* end victim breath */
    
    /* start give breath */
    Timer t, q;
    vector<float> b;
    /* end give breath */
    vector<float> c;
    NeoStrip *strip;
    MPL3115 barometer;
    bool spike;
    float pressure_threshold;
};