#include "mbed.h"
#include "Adafruit_LEDBackpack.h"
#include "Adafruit_GFX.h"
#include "math.h"

#define         SOURCE_FILE0    "/local/f0.bmp"
#define         SOURCE_FILE1    "/local/f1.bmp"
#define         SOURCE_FILE2    "/local/f2.bmp"
#define         SOURCE_FILE3    "local/f3.bmp"
#define         BUFFER_SIZE     1024

LocalFileSystem local("local");
I2C i2c(p28,p27);
Adafruit_8x8matrix matrix = Adafruit_8x8matrix(&i2c);

InterruptIn in0(p21);
InterruptIn in1(p22);
InterruptIn in2(p23);
InterruptIn in3(p24);

float lx,ly;

void allclear()
{
    for(lx=0; lx<8; lx++) {
        for(ly=0; ly<8; ly++) {
            matrix.drawPixel(lx,ly,0, 1);
        }
    }
    matrix.writeDisplay();
}

int otob(unsigned char red,unsigned char green,unsigned char blue ){
    int d;
    int data;
    d = (int)red + (int)green + (int)blue;
    if(d==0) {
        data=1;
    } else {
        data=0;
    }
    return data;
}
int btod(int hairetu[8]){
    int rtn;
    rtn += hairetu[0]*128;
    rtn += hairetu[1]*64;
    rtn += hairetu[2]*32;
    rtn += hairetu[3]*16;
    rtn += hairetu[4]*8;
    rtn += hairetu[5]*4;
    rtn += hairetu[6]*2;
    rtn += hairetu[7]*1;
    return rtn;
}

//defined variables
/*****************************************************************/
typedef struct  bmp_header_st    {
    unsigned short  bfType            __attribute__((packed));
    unsigned long   bfSize            __attribute__((packed));
    unsigned short  bfReserved1       __attribute__((packed));
    unsigned short  bfReserved2       __attribute__((packed));
    unsigned long   bfOffBits         __attribute__((packed));

    unsigned long   biSize            __attribute__((packed));
    long            biWidth           __attribute__((packed));
    long            biHeight          __attribute__((packed));
    unsigned short  biPlanes          __attribute__((packed));
    unsigned short  biBitCount        __attribute__((packed));
    unsigned long   biCompression     __attribute__((packed));
    unsigned long   biSizeImage       __attribute__((packed));
    long            biXPixPerMeter    __attribute__((packed));
    long            biYPixPerMeter    __attribute__((packed));
    unsigned long   biClrUsed         __attribute__((packed));
    unsigned long   biCirImportant    __attribute__((packed));
} bmp_header;

typedef struct  color_palette_st    {
    unsigned char    red;
    unsigned char    green;
    unsigned char    blue;
    unsigned char    dummy;
} color_palette;

unsigned char    buffer[ BUFFER_SIZE ];
FILE             *fs;
bmp_header       bh;
color_palette    cp[256];
unsigned long    readsize;
unsigned long    i;
unsigned long    ofset    = 0;

int x[24][8];
int *px=&x[0][0];
long a;
int y1[8], y2[8], y3[8], y4[8], y5[8], y6[8], y7[8], y8[8], y9[8], y10[8], y11[8], y12[8];
int y13[8],y14[8],y15[8],y16[8],y17[8],y18[8],y19[8],y20[8],y21[8],y22[8], y23[8], y24[8];
/****************************************************************************************/

int DatatoArray(){
    for(int num=0; num<8; num++) {
        y1[num]=*(px+24*num); y2[num]=*((px+24*num)+1); y3[num]=*((px+24*num)+2);
        y4[num]=*((px+24*num)+3); y5[num]=*((px+24*num)+4); y6[num]=*((px+24*num)+5);
        y7[num]=*((px+24*num)+6); y8[num]=*((px+24*num)+7); y9[num]=*((px+24*num)+8);
        y10[num]=*((px+24*num)+9); y11[num]=*((px+24*num)+10); y12[num]=*((px+24*num)+11);
        y13[num]=*((px+24*num)+12); y14[num]=*((px+24*num)+13); y15[num]=*((px+24*num)+14);
        y16[num]=*((px+24*num)+15); y17[num]=*((px+24*num)+16); y18[num]=*((px+24*num)+17);
        y19[num]=*((px+24*num)+18); y20[num]=*((px+24*num)+19); y21[num]=*((px+24*num)+20);
        y22[num]=*((px+24*num)+21); y23[num]=*((px+24*num)+22); y24[num]=*((px+24*num)+23);
    }
}

void kakikaki(){
    matrix.begin(0x71); allclear();
    for(int count = 0; count<8; count++) {
        matrix.drawPixel(count,0,1,y1[count]); matrix.drawPixel(count,1,1,y2[count]);
        matrix.drawPixel(count,2,1,y3[count]); matrix.drawPixel(count,3,1,y4[count]);
        matrix.drawPixel(count,4,1,y5[count]); matrix.drawPixel(count,5,1,y6[count]);
        matrix.drawPixel(count,6,1,y7[count]); matrix.drawPixel(count,7,1,y8[count]);
    }
    matrix.writeDisplay(); wait_ms(250);  matrix.clear();
    
    matrix.begin(0x72); allclear();
    for(int count = 0; count<8; count++) {
        matrix.drawPixel(count,0,1,y9[count]);  matrix.drawPixel(count,1,1,y10[count]);
        matrix.drawPixel(count,2,1,y11[count]); matrix.drawPixel(count,3,1,y12[count]);
        matrix.drawPixel(count,4,1,y13[count]); matrix.drawPixel(count,5,1,y14[count]);
        matrix.drawPixel(count,6,1,y15[count]); matrix.drawPixel(count,7,1,y16[count]);
    }
    matrix.writeDisplay(); wait_ms(250); matrix.clear();
    
    matrix.begin(0x74); allclear();
    for(int count = 0; count<8; count++) {
        matrix.drawPixel(count,0,1,y17[count]); matrix.drawPixel(count,1,1,y18[count]);
        matrix.drawPixel(count,2,1,y19[count]); matrix.drawPixel(count,3,1,y20[count]);
        matrix.drawPixel(count,4,1,y21[count]); matrix.drawPixel(count,5,1,y22[count]);
        matrix.drawPixel(count,6,1,y23[count]); matrix.drawPixel(count,7,1,y24[count]);
    }
    matrix.writeDisplay(); wait_ms(250); matrix.clear();
}

int HiperRead0(){
    if ( NULL == (fs    = fopen( SOURCE_FILE0, "rb" )) ) {
        printf( "file open error when oening file \"%s\"\r\n", SOURCE_FILE0 );
        return ( 1 );
    }
    fread( &bh, sizeof( bh ), 1, fs );

    for(i = 0; i < 256; i++) { fread( &(cp[i]), sizeof( color_palette ), 1, fs ); }

    while ( 0 != (readsize = fread( buffer, sizeof( unsigned char ), BUFFER_SIZE, fs)) ) {
        int data[readsize];
        printf("%ld\r\n",readsize);
        for ( i = 0; i < readsize; i++ ) {
            data[i] = otob( cp[ buffer[i] ].red, cp[ buffer[i] ].green, cp[ buffer[i] ].blue);
            ofset++;
        }
        for(int size=0; size<readsize/8; size++) {
            int b=8*size;
            for(a = b; a<(b+8); a++) { x[size][a-b] = data[a]; }
        }
        for(int g=0; g<readsize; g++) {
            printf("%d",*(px+g));
            if( ((g+1)%24) ==0 && g!=0) { printf("\r\n"); }
        }
    }
    printf( "\r\ndone.\r\n\r\n" );  fclose(fs);

    DatatoArray(); kakikaki();
    return 0;
}

int HiperRead1(){
    if ( NULL == (fs    = fopen( SOURCE_FILE1, "rb" )) ) {
        printf( "file open error when oening file \"%s\"\r\n", SOURCE_FILE1 );
        return ( 1 );
    }
    fread( &bh, sizeof( bh ), 1, fs );

    for(i = 0; i < 256; i++) { fread( &(cp[i]), sizeof( color_palette ), 1, fs ); }

    while ( 0 != (readsize = fread( buffer, sizeof( unsigned char ), BUFFER_SIZE, fs)) ) {
        int data[readsize];
        printf("%ld\r\n",readsize);
        for ( i = 0; i < readsize; i++ ) {
            data[i] = otob( cp[ buffer[i] ].red, cp[ buffer[i] ].green, cp[ buffer[i] ].blue);
            ofset++;
        }
        for(int size=0; size<readsize/8; size++) {
            int b=8*size;
            for( a = b; a<(b+8); a++ ){ x[size][a-b] = data[a]; }
        }
        for(int g=0; g<readsize; g++) {
            printf("%d",*(px+g));
            if( ((g+1)%24) ==0 && g!=0 ){ printf("\r\n"); }
        }
    }
    printf( "\r\ndone.\r\n\r\n" );  fclose(fs);

    DatatoArray(); kakikaki();
    return 0;
}

int HiperRead2(){
    if ( NULL == (fs    = fopen( SOURCE_FILE2, "rb" )) ) {
        printf( "file open error when oening file \"%s\"\r\n", SOURCE_FILE2 );
        return ( 1 );
    }
    fread( &bh, sizeof( bh ), 1, fs );

    for(i = 0; i < 256; i++) { fread( &(cp[i]), sizeof( color_palette ), 1, fs ); }

    while ( 0 != (readsize = fread( buffer, sizeof( unsigned char ), BUFFER_SIZE, fs)) ) {
        int data[readsize];
        printf("%ld\r\n",readsize);
        for ( i = 0; i < readsize; i++ ) {
            data[i] = otob( cp[ buffer[i] ].red, cp[ buffer[i] ].green, cp[ buffer[i] ].blue);
            ofset++;
        }
        for(int size=0; size<readsize/8; size++) {
            int b=8*size;
            for(a = b; a<(b+8); a++) { x[size][a-b] = data[a]; }
        }
        for(int g=0; g<readsize; g++) {
            printf("%d",*(px+g));
            if( ((g+1)%24) ==0 && g!=0) { printf("\r\n"); }
        }
    }
    printf( "\r\ndone.\r\n\r\n" );  fclose(fs);

    DatatoArray(); kakikaki();
    return 0;
}

int HiperRead3(){
    if ( NULL == (fs    = fopen( SOURCE_FILE3, "rb" )) ) {
        printf( "file open error when oening file \"%s\"\r\n", SOURCE_FILE3 );
        return ( 1 );
    }
    fread( &bh, sizeof( bh ), 1, fs );

    for(i = 0; i < 256; i++) { fread( &(cp[i]), sizeof( color_palette ), 1, fs ); }

    while ( 0 != (readsize = fread( buffer, sizeof( unsigned char ), BUFFER_SIZE, fs)) ) {
        int data[readsize];
        printf("%ld\r\n",readsize);
        for ( i = 0; i < readsize; i++ ) {
            data[i] = otob( cp[ buffer[i] ].red, cp[ buffer[i] ].green, cp[ buffer[i] ].blue);
            ofset++;
        }
        for(int size=0; size<readsize/8; size++) {
            int b=8*size;
            for(a = b; a<(b+8); a++) { x[size][a-b] = data[a]; }
        }
        for(int g=0; g<readsize; g++) {
            printf("%d",*(px+g));
            if( ((g+1)%24) ==0 && g!=0) { printf("\r\n"); }
        }
    }
    printf( "\r\ndone.\r\n\r\n" );  fclose(fs);

    DatatoArray(); kakikaki();
    return 0;
}

void rin0(){ HiperRead0(); }
void rin1(){ HiperRead1(); }
void rin2(){ HiperRead2(); }
void rin3(){ HiperRead3(); }

int main(){
    in0.rise(&rin0); in1.rise(&rin1); in2.rise(&rin2); in3.rise(&rin3);
    
    while(1){
        printf("waiting\r\n");
        wait(10);
    }
}