/**************************************************************************************/
/**************************************************************************************/
/*SMART Remote Controller
 
 Kevin D. Ostler copyright 2016 */
/**************************************************************************************/
/**************************************************************************************/
#include "mbed.h"
#include "mRotaryEncoder.h"
#define MAX 100
#define MIN 0

mRotaryEncoder adjust_enc(p9, p10, p11);//pinA,pinB,pinSW

float resolution = 1.0;
float adjust_set = 0.0;
float adjust_last = 0.0;
bool button = 1;

float AdjustVal(float adjust_val){
    adjust_val += (adjust_enc.Get() * resolution);    
    if( adjust_val >= MAX){ 
        adjust_val = MAX;
        }else if(adjust_val <= MIN){ 
            adjust_val = MIN;         
        }
        adjust_enc.Set(0);
    return adjust_val;
}
void Set_Resolution(void){
    button = !button;
    if( resolution == 1.0 ){
        resolution = 0.1;
        }else{
            resolution = 1.0;
            }
}           

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX); // tx, rx

int main() {
    pc.baud(921600);
    pc.format(8,Serial::None,1);
    wait(0.1);
    adjust_enc.attachSW( &Set_Resolution);
    while(1) {
        myled = 1;
        adjust_set = AdjustVal(adjust_set);
        //adjust_last = adjust_set;
        pc.printf("Adjust Level =  %f Resolution = %f Button = %d\n\r" ,adjust_set/100, resolution, button);
        wait(0.2);
        myled = 0;
        pc.printf("Adjust Level =  %f Resolution = %f Button = %d\n\r" ,adjust_set/100, resolution, button);
        wait(0.2);
    }
}
