/******************************************************************************/
/******************************************************************************/
#include "mbed.h"
#include "sample_service.h"

//Set client address here
//#define CLIENT_ADDRESS {0x36, 0x1F, 0xAC, 0x29, 0x6A, 0xBC}
#define CLIENT_ADDRESS {0x05, 0x25, 0xAC, 0x29, 0x6A, 0xBC};

volatile int connected = FALSE;
volatile uint8_t set_connectable = 1;
volatile uint16_t connection_handle = 0;
volatile uint8_t notification_enabled = FALSE;
volatile uint8_t read_finished = FALSE;

uint8_t *readData;
uint8_t dataLength;

extern Serial pc;
/******************************************************************************/
/******************************************************************************/

#define COPY_UUID_128(uuid_struct, uuid_15, uuid_14, uuid_13, uuid_12, uuid_11, uuid_10, uuid_9, uuid_8, uuid_7, uuid_6, uuid_5, uuid_4, uuid_3, uuid_2, uuid_1, uuid_0) \
  do {\
  	uuid_struct.uuid128[0] = uuid_0; uuid_struct.uuid128[1] = uuid_1; uuid_struct.uuid128[2] = uuid_2; uuid_struct.uuid128[3] = uuid_3; \
	uuid_struct.uuid128[4] = uuid_4; uuid_struct.uuid128[5] = uuid_5; uuid_struct.uuid128[6] = uuid_6; uuid_struct.uuid128[7] = uuid_7; \
	uuid_struct.uuid128[8] = uuid_8; uuid_struct.uuid128[9] = uuid_9; uuid_struct.uuid128[10] = uuid_10; uuid_struct.uuid128[11] = uuid_11; \
	uuid_struct.uuid128[12] = uuid_12; uuid_struct.uuid128[13] = uuid_13; uuid_struct.uuid128[14] = uuid_14; uuid_struct.uuid128[15] = uuid_15; \
	}while(0)



/******************************************************************************/
/******************************************************************************/
void Make_Connection(void)
{  
    tBleStatus ret;
    
    // 
    tBDAddr bdaddr = CLIENT_ADDRESS;

    ret = aci_gap_create_connection(0x4000, 0x4000, PUBLIC_ADDR, bdaddr, PUBLIC_ADDR, 9, 9, 0, 60, 1000 , 1000);

    if (ret != 0) {
        pc.printf("Error while starting connection.\n");
        Clock_Wait(100);
    }

}
/******************************************************************************/
/******************************************************************************/
void sendData(uint16_t handle, uint8_t* data_buffer, uint8_t Nb_bytes)
{
    aci_gatt_write_without_response(connection_handle, handle, Nb_bytes, data_buffer);
}

/******************************************************************************/
/******************************************************************************/

uint8_t *readValue(unsigned short handle, uint8_t* len)
{
    volatile unsigned char res;
    static uint32_t timeout = 0;
    
    res = aci_gatt_read_charac_val(connection_handle, handle);
    
    timeout = 0;
    while ((!read_finished)&&(timeout < READ_TIMEOUT))
    {
        HCI_Process();
        timeout++;
    }
    if (timeout == READ_TIMEOUT)
    {
        dataLength = 0;
    }
    
    *len = dataLength;
    
    read_finished = 0;
    return readData;
    
}

/******************************************************************************/
/******************************************************************************/
void enableNotification()
{
  uint8_t client_char_conf_data[] = {0x01, 0x00}; // Enable notifications
  struct timer t;
  Timer_Set(&t, CLOCK_SECOND*10);
  
  while(aci_gatt_write_charac_descriptor(connection_handle, 0x0060, 2, client_char_conf_data)==BLE_STATUS_NOT_ALLOWED){
    /* Radio is busy */
    if(Timer_Expired(&t)) break;
  }
  notification_enabled = TRUE;
}

/******************************************************************************/
/******************************************************************************/
void GAP_ConnectionComplete_CB(uint8_t addr[6], uint16_t handle)
{  
  connected = TRUE;
  connection_handle = handle;
  
}

/******************************************************************************/
/******************************************************************************/
void GAP_DisconnectionComplete_CB(void)
{
  connected = FALSE;
  set_connectable = TRUE;
  notification_enabled = FALSE;
}

/******************************************************************************/
/******************************************************************************/

void GATT_Notification_CB(uint16_t attr_handle, uint8_t attr_len, uint8_t *attr_value)
{
	//reserved
}

/******************************************************************************/
/******************************************************************************/

void GATT_Read_CB(uint16_t attr_handle, uint8_t attr_len, uint8_t *attr_value)
{
    readData = attr_value;
    dataLength = attr_len;
    read_finished = 1;
}

/******************************************************************************/
/******************************************************************************/

void HCI_Event_CB(void *pckt)
{
  hci_uart_pckt *hci_pckt = (hci_uart_pckt *)pckt;
  hci_event_pckt *event_pckt = (hci_event_pckt*)hci_pckt->data;
  
  if(hci_pckt->type != HCI_EVENT_PKT)
    return;
  
  switch(event_pckt->evt){
    
  case EVT_DISCONN_COMPLETE:
    {
      GAP_DisconnectionComplete_CB();
    }
    break;
    
  case EVT_LE_META_EVENT:
    {
      evt_le_meta_event *evt = (evt_le_meta_event *)event_pckt->data;
      
      switch(evt->subevent){
      case EVT_LE_CONN_COMPLETE:
        {
          evt_le_connection_complete *cc = (evt_le_connection_complete *)evt->data;
          GAP_ConnectionComplete_CB(cc->peer_bdaddr, cc->handle);
        }
        break;
      }
    }
    break;
    
  case EVT_VENDOR:
    {
      evt_blue_aci *blue_evt = (evt_blue_aci *)event_pckt->data;
      switch(blue_evt->ecode){
        
                case EVT_BLUE_GATT_NOTIFICATION: {
                    evt_gatt_attr_notification *evt = (evt_gatt_attr_notification*)blue_evt->data;
                    GATT_Notification_CB(evt->attr_handle, evt->data_length - 2, evt->attr_value);
                }
                break;
                case EVT_BLUE_ATT_READ_RESP: {
                    evt_gatt_procedure_complete *evt = (evt_gatt_procedure_complete*)blue_evt->data;
                    GATT_Read_CB(evt->conn_handle, evt->data_length, evt->data);

                }
                break;
            }
    }
    break;
  }    
}
/******************************************************************************/
/******************************************************************************/

/*****************************END OF FILE**************************************/
