#include <math.h>
#include "stm32f4xx_hal.h"

/* Conversion algorithm for target temperature */
double calcTmpTarget(uint8_t* rawData)
{
  uint16_t rawT = (rawData[1] << 8) | rawData[0]; 
  double m_tmpAmb = ((rawData[3] << 8) | rawData[2] )/128.0;
      
  //-- calculate target temperature
  double Vobj2 = (double)(uint16_t)rawT;
  Vobj2 *= 0.00000015625;

  double Tdie2 = m_tmpAmb + 273.15;
  const double S0 = 6.4E-14;            // Calibration factor

  const double a1 = 1.75E-3;
  const double a2 = -1.678E-5;
  const double b0 = -2.94E-5;
  const double b1 = -5.7E-7;
  const double b2 = 4.63E-9;
  const double c2 = 13.4;
  const double Tref = 298.15;
  double S = S0*(1+a1*(Tdie2 - Tref)+a2*pow((Tdie2 - Tref),2));
  double Vos = b0 + b1*(Tdie2 - Tref) + b2*pow((Tdie2 - Tref),2);
  double fObj = (Vobj2 - Vos) + c2*pow((Vobj2 - Vos),2);
  double tObj = pow(pow(Tdie2,4) + (fObj/S),.25);
  tObj = (tObj - 273.15);

  return  m_tmpAmb;//tObj;
}

double calcHumTmp(uint16_t rawT)
{
  double v;

  //-- calculate temperature [deg C] --
  v = -46.85 + 175.72/65536 *(double)(uint16_t)rawT;

  return v;
}

/*  Conversion algorithm, humidity */

double calcHumRel(uint8_t* rawData)
{
  double v;
  
  uint16_t rawH = (rawData[3] << 8) | rawData[2]; 

  rawH &= ~0x0003; // clear bits [1..0] (status bits)
  //-- calculate relative humidity [%RH] --
  v = -6.0 + 125.0/65536 * (double)rawH; // RH= -6 + 125 * SRH/2^16

  return v;
}
