 /*
 Universidad Galileo
 Pablo Torres
 13000271
 Sistemas Embebidos
 Proyecto Final
 */   

#include "mbed.h"
#include "BME280.h"
 
Serial pc(USBTX, USBRX);
 
//sensor de temp-pres-alt
BME280 sensor(PB_9,PB_8); // SDA/D14 & SCL/15
// sensor de humedad
AnalogIn   ain(PA_0); //A0
DigitalOut Led1(LED1); //LED para alerta de humedad
//Sensor UV
AnalogIn sensorUV(PA_1); // A1
DigitalOut Led2(LED2); // LED para alerta UV "azul 450 - Rojo 650" 
 
int main() {
  
    while(1) {
        printf("Reset----------------- \r\n" );
    
        //----------------------------------------------------------------
        //Sección de BME280
        pc.printf("%2.2f degC, %04.2f hPa, %2.2f %%\r\n", sensor.getTemperature(), sensor.getPressure(), sensor.getHumidity());
        wait(1);
        
        //----------------------------------------------------------------
        // Sección de humedad
            // 0 -> 50% humedo
            // 50 -> 100% secado
         if(ain > 0.7f) {
            Led1 = 1;
        } else {
            Led1 = 0;
        }
        printf("Humedad: %3.3f%%\r\n", ain.read()*100.0f);
        //printf("normalized: 0x%04X \n", ain.read_u16());
        wait(0.2f);
        
        //--------------------------------------------------------------
        //Sección UV
                //8->10% = indoors at night 
                //100% = full sunlight 
         if(ain > 0.5f) {
            Led2 = 1;
        } else {
            Led2 = 0;
        }
        printf("UV: %3.3f%%\r\n", sensorUV.read()*100.0f);
        //printf("normalized: 0x%04X \n", ain.read_u16());
        wait(0.2f);
        
    }
}




//----------------------------------------------------------------------------

/*
#include "mbed.h"
 #include "DHT11.h"
 
  DHT11 d = (PB_5);
  int s;
  
  main()
  {
  
    //  e = e.ErrorDHT11();
      
      while(1){
         s = d.readData();
         wait(0.1);
         printf("Reset----------------- \r\n" );
          if (s != DHT11::OK) {
              printf("Error!\r\n");
              //e = s + '0';
              printf("%d\n",s);
              printf("\r\n");
          }
          else {
              printf("T:%d, H:%d\r\n", d.readTemperature(), d.readHumidity());
          }
        wait(1);
      }
  }
*/


/*
#include "mbed.h"
DigitalOut led(LED2);
int main() {
        while (1) {
                led = 1;
                wait(0.5);
                led = 0;
                wait(0.5);
        }
}
*/