#include "mbed.h"
#include "snd_wave_generator/SoundWaveGenerator.h"
#include "snd_wave_generator/TriangleWave.h"
#include "snd_wave_generator/SineWave.h"
#include "snd_wave_generator/WaveCombo.h"

using namespace snd_wave_generator;

int main() {
    SineWave sw(440);
    TriangleWave tw(1000);
    WaveCombo cw;
    cw.add(&sw).add(&tw);
    SoundWaveGenerator generator(16000);
    
    BusOut leds(LED1, LED2, LED4);

    while(1) {
        leds = 1;
        generator.play(&sw);
        wait(1);
        leds = 4;
        generator.stop();
        wait(0.2);
        leds = 2;
        generator.play(&tw);
        wait(1);
        leds = 3;
        generator.play(&cw);
        wait(1);
        leds = 4;
        generator.stop();
        wait(2);
    }
}
